"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CLIEngine = exports.RunStats = exports.RunResult = void 0;
const fs_1 = require("fs");
const InlineTransformer_1 = require("./InlineTransformer");
const iterateSources_1 = require("./iterateSources");
const TransformRunner_1 = require("./TransformRunner");
const getStream = require("get-stream");
class RunResult {
    constructor(stats) {
        this.stats = stats;
    }
}
exports.RunResult = RunResult;
class RunStats {
    constructor(modified = 0, errors = 0, total = 0) {
        this.modified = modified;
        this.errors = errors;
        this.total = total;
    }
}
exports.RunStats = RunStats;
class CLIEngine {
    constructor(config, onTransform = () => {
        // do nothing by default
    }) {
        this.config = config;
        this.onTransform = onTransform;
    }
    loadPlugins() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.config.loadBabelTranspile();
            this.config.loadRequires();
            return yield this.config.getBabelPlugins();
        });
    }
    run() {
        var e_1, _a;
        return __awaiter(this, void 0, void 0, function* () {
            const plugins = yield this.loadPlugins();
            let modified = 0;
            let errors = 0;
            let total = 0;
            const dryRun = this.config.dry;
            let sources;
            if (this.config.stdio) {
                sources = (function getStdinSources() {
                    return __asyncGenerator(this, arguments, function* getStdinSources_1() {
                        yield yield __await(new TransformRunner_1.Source('<stdin>', yield __await(getStream(process.stdin))));
                    });
                })();
            }
            else {
                sources = (0, iterateSources_1.iterateSources)(this.config.sourcePaths, {
                    extensions: this.config.extensions,
                });
            }
            const runner = new TransformRunner_1.TransformRunner(sources, new InlineTransformer_1.InlineTransformer(plugins, this.config.parserPlugins));
            try {
                for (var _b = __asyncValues(runner.run()), _c; _c = yield _b.next(), !_c.done;) {
                    const result = _c.value;
                    this.onTransform(result);
                    if (result.kind === TransformRunner_1.SourceTransformResultKind.Transformed) {
                        if (this.config.stdio) {
                            process.stdout.write(result.output);
                        }
                        else {
                            if (result.output !== result.source.content) {
                                modified++;
                                if (!dryRun) {
                                    yield fs_1.promises.writeFile(result.source.path, result.output, 'utf8');
                                }
                            }
                        }
                    }
                    else if (result.error) {
                        errors++;
                    }
                    total++;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) yield _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return new RunResult(new RunStats(modified, errors, total));
        });
    }
}
exports.CLIEngine = CLIEngine;
//# sourceMappingURL=CLIEngine.js.map