import { Config } from './Config';
import { SourceTransformResult } from './TransformRunner';
export declare class RunResult {
    readonly stats: RunStats;
    constructor(stats: RunStats);
}
export declare class RunStats {
    readonly modified: number;
    readonly errors: number;
    readonly total: number;
    constructor(modified?: number, errors?: number, total?: number);
}
export declare class CLIEngine {
    readonly config: Config;
    readonly onTransform: (result: SourceTransformResult) => void;
    constructor(config: Config, onTransform?: (result: SourceTransformResult) => void);
    private loadPlugins;
    run(): Promise<RunResult>;
}
