import ts from "typescript";
import { ChangeSet } from "../../../utils/textChanges.js";
import { PositionInfo } from "../../LinterContext.js";
import { Attribute, Position } from "sax-wasm";
import XmlEnabledFix from "./XmlEnabledFix.js";
import { FixHelpers } from "./Fix.js";
/**
 * Fix a global property access. Requires a module name which will be imported and replaces the defined property access.
 * The property access is in the order of the AST, e.g. ["core", "ui", "sap"]
 */
export default abstract class PropertyAssignmentBaseFix extends XmlEnabledFix {
    protected sourcePosition: PositionInfo | undefined;
    protected startPos: number | undefined;
    protected endPos: number | undefined;
    protected trailingCommaPos: number | undefined;
    constructor();
    visitLinterNode(node: ts.Node, sourcePosition: PositionInfo, _helpers: FixHelpers): boolean;
    getNodeSearchParameters(): {
        nodeTypes: ts.SyntaxKind[];
        xmlEventTypes: 64[];
        position: PositionInfo;
    };
    visitAutofixNode(node: ts.Node, _position: number, _sourceFile: ts.SourceFile): boolean;
    visitAutofixXmlNode(node: Attribute, toPosition: (pos: Position) => number): boolean;
    getAffectedSourceCodeRange(): {
        start: number;
        end: number;
    };
    generateChanges(): ChangeSet | ChangeSet[] | undefined;
}
