import { SourceFile } from "typescript";
import LinterContext, { LinterParameters } from "../LinterContext.js";
import type SharedLanguageService from "./SharedLanguageService.js";
import SourceFileReporter from "./SourceFileReporter.js";
import { JSONSchemaForSAPUI5Namespace } from "../../manifest.js";
export default class TypeLinter {
    #private;
    constructor({ workspace, filePathsWorkspace, context }: LinterParameters, libraryDependencies: JSONSchemaForSAPUI5Namespace["dependencies"]["libs"], sharedLanguageService: SharedLanguageService);
    lint(): Promise<void>;
    getContext(): LinterContext;
    getSourceMap(resourcePath: string): string | undefined;
    getSourceFileReporter(sourceFile: SourceFile): SourceFileReporter;
    addMessagesToContext(): void;
}
