import ts from "typescript";
import LanguageServiceHostProxy from "./LanguageServiceHostProxy.js";
export default class DocumentRegistryProxy {
    documentRegistry = ts.createDocumentRegistry();
    // ts.DocumentRegistry implementation:
    acquireDocument(_fileName, _compilationSettingsOrHost, _scriptSnapshot, _version, _scriptKind, _sourceFileOptions) {
        throw new Error("Method not implemented.");
    }
    acquireDocumentWithKey(fileName, path, compilationSettingsOrHost, key, scriptSnapshot, version, scriptKind, sourceFileOptions) {
        return this.documentRegistry.acquireDocumentWithKey(fileName, path, compilationSettingsOrHost, key, scriptSnapshot, version, scriptKind, sourceFileOptions);
    }
    updateDocument(_fileName, _compilationSettingsOrHost, _scriptSnapshot, _version, _scriptKind, _sourceFileOptions) {
        throw new Error("Method not implemented.");
    }
    updateDocumentWithKey(fileName, path, compilationSettingsOrHost, key, scriptSnapshot, version, scriptKind, sourceFileOptions) {
        return this.documentRegistry.updateDocumentWithKey(fileName, path, compilationSettingsOrHost, key, scriptSnapshot, version, scriptKind, sourceFileOptions);
    }
    getKeyForCompilationSettings(settings) {
        return this.documentRegistry.getKeyForCompilationSettings(settings);
    }
    releaseDocument(_fileName, _compilationSettings, _scriptKind) {
        throw new Error("Method not implemented.");
    }
    releaseDocumentWithKey(path, key, scriptKind, impliedNodeFormat) {
        if (LanguageServiceHostProxy.isSharedTypesFile(path)) {
            // Do not release documents in /types/ as they are shared across multiple projects
            // and should still be cached even when no longer needed by a specific project.
            return;
        }
        if (scriptKind && impliedNodeFormat) {
            this.documentRegistry.releaseDocumentWithKey(path, key, scriptKind, impliedNodeFormat);
        }
        else {
            this.documentRegistry.releaseDocumentWithKey(path, key, scriptKind);
        }
    }
    reportStats() {
        return this.documentRegistry.reportStats();
    }
}
//# sourceMappingURL=DocumentRegistryProxy.js.map