import ts from "typescript";
import { ChangeAction } from "../../../utils/textChanges.js";
import AccessExpressionBaseFix, { AccessExpressionBaseFixParams } from "./AccessExpressionBaseFix.js";
import { FixScope } from "./BaseFix.js";
import { Ui5TypeInfo } from "../Ui5TypeInfo.js";
export interface AccessExpressionFixParams extends AccessExpressionBaseFixParams {
    /**
     * Which scope, i.e. number of access expression counting from the root should the replacement affect.
     * Examples for the code "sap.module.property":
     * - "scope = 0" will replace the whole "sap.module.property"
     * - "scope = 1" will replace "sap.module.method"
     * - "scope = 2" will replace "sap.module"
     *
     * If not set, the default value is 0.
     */
    scope?: number | FixScope;
    /**
     * Property access on the module or global
     *
     * Example: Migrating "module.property" to "otherModule.otherProperty"
     * would require this to be set to "otherProperty"
     */
    propertyAccess?: string;
}
/**
 * Fix a property access. This could also be the property access of a call expression, allowing for a more general
 * replacement in cases where the arguments or other conditions of the call expression do not matter.
 */
export default class AccessExpressionFix extends AccessExpressionBaseFix {
    protected params: AccessExpressionFixParams;
    constructor(params: AccessExpressionFixParams, ui5TypeInfo: Ui5TypeInfo);
    visitAutofixNode(node: ts.Node, position: number, sourceFile: ts.SourceFile): boolean;
    generateChanges(): {
        action: ChangeAction;
        start: number;
        end: number;
        value: string;
    } | undefined;
}
