import ts from "typescript";
export default class SourceFileMetadataCollector {
    private metadata;
    constructor();
    visitNode(node: ts.Node, sourceFile: ts.SourceFile): void;
    addControllerClass(node: ts.ClassLikeDeclaration, filePath: string): void;
    collectControllerInfo(sourceFile: ts.SourceFile): void;
    getMetadata(): {
        controllerInfo: {
            classNodeByPath: Map<string, ts.ClassLikeDeclaration>;
            nameToPath: Map<string, Set<string>>;
        };
    };
}
