import { SaxEventType, Tag as SaxTag, Text as SaxText } from "sax-wasm";
import { extractDirective, parseXml } from "../../utils/xmlParser.js";
function parseTag(event, tag, extractedTags) {
    if (event === SaxEventType.OpenTag &&
        tag.name === "link") {
        if (tag.attributes.some((attr) => {
            return (attr.name.value === "rel" &&
                attr.value.value === "stylesheet");
        })) {
            extractedTags.stylesheetLinkTags.push(tag);
        }
        ;
    }
    else if (event === SaxEventType.CloseTag &&
        tag.name === "script") {
        const isJSScriptTag = tag.attributes.every((attr) => {
            // The "type" attribute of the script tag should be
            // 1. not set (default),
            // 2. an empty string,
            // 3. or a JavaScript MIME type (text/javascript)
            // https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script/type#attribute_is_not_set_default_an_empty_string_or_a_javascript_mime_type
            return attr.name.value !== "type" ||
                (attr.name.value === "type" &&
                    ["",
                        "module",
                        "text/javascript",
                        "application/javascript", /* legacy */
                    ].includes(attr.value.value.toLowerCase()));
        });
        if (isJSScriptTag) {
            extractedTags.scriptTags.push(tag);
        }
    }
}
function parseComment(comment, directives) {
    const directive = extractDirective(comment);
    if (directive) {
        directives.add(directive);
    }
}
export async function extractHTMLTags(contentStream) {
    const extractedTags = {
        scriptTags: [],
        stylesheetLinkTags: [],
    };
    const directives = new Set();
    await parseXml(contentStream, (event, tag) => {
        if (tag instanceof SaxTag) {
            parseTag(event, tag.toJSON(), extractedTags);
        }
        else if (tag instanceof SaxText && event === SaxEventType.Comment) {
            parseComment(tag.toJSON(), directives);
        }
    });
    return { extractedTags, directives };
}
//# sourceMappingURL=parser.js.map