import ts from "typescript";
import { ChangeSet } from "../utils/textChanges.js";
import { ExistingModuleDeclarationInfo } from "./autofix.js";
import { RequireExpression } from "../linter/ui5Types/amdTranspiler/parseRequire.js";
import { ModuleDeclaration } from "../linter/ui5Types/amdTranspiler/parseModuleDeclaration.js";
interface DependencyMapValue {
    node: ts.StringLiteralLike;
    index: number;
    leadingComma?: ts.Token<ts.SyntaxKind.CommaToken>;
    trailingComma?: ts.Token<ts.SyntaxKind.CommaToken>;
}
export declare const NO_PARAM_FOR_DEPENDENCY: unique symbol;
export declare const UNSUPPORTED_PARAM_FOR_DEPENDENCY: unique symbol;
type ModuleName = string;
export type Dependencies = Map<ModuleName, string | typeof NO_PARAM_FOR_DEPENDENCY | typeof UNSUPPORTED_PARAM_FOR_DEPENDENCY>;
export declare function hasBody(moduleDeclaration: ModuleDeclaration | RequireExpression): boolean;
export declare function getFactoryBody(moduleDeclaration: ExistingModuleDeclarationInfo): ts.Node | undefined;
export declare function getDependencies(moduleDeclaration: ModuleDeclaration | RequireExpression, resourcePath: string): Dependencies;
export declare function createDependencyInfo(dependencyArray: ts.ArrayLiteralExpression | undefined, resourcePath: string): {
    dependencyMap: Map<string, DependencyMapValue>;
    mostUsedQuoteStyle: string;
};
export declare function addDependencies(defineCall: ts.CallExpression, moduleDeclarationInfo: ExistingModuleDeclarationInfo, changeSet: ChangeSet[], resourcePath: string, removedDependencies: Set<string>): void;
export declare function removeDependencies(dependenciesToRemove: Set<string>, moduleDeclarationInfo: ExistingModuleDeclarationInfo, changeSet: ChangeSet[], resourcePath: string, declaredIdentifiers: Set<string>): void;
export {};
