/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.codemods.NodeBasedRecipe;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;

@Incubating(since="0.20.0")
public final class ReactI18Next
extends NodeBasedRecipe {
    @Option(displayName="Translation file path", description="Path to the translation JSON file where extracted strings will be stored. Defaults to `translations.json` in the root of the project.", example="./src/locales/en.json", required=false)
    private final @Nullable String translationFilePath;
    @Option(displayName="Import name", description="The package name to import translation functions from. Required.", example="react-i18next")
    private final String importName;
    @Option(displayName="Translation root key", description="Root key in the translation file to organize translations under. Defaults to `common`.", example="common", required=false)
    private final @Nullable String translationRoot;
    @Option(displayName="File pattern", description="Glob pattern to specify which files to transform. Defaults to all files.", example="src/**/*.tsx", required=false)
    private final @Nullable String filePattern;
    @Option(displayName="Parser", description="Parser to use for transforming files. Defaults to auto-detection based on file extensions (`tsx`/`ts`/`babel`).", example="tsx", required=false)
    private final @Nullable String parser;

    public String getDisplayName() {
        return "React i18next internationalization";
    }

    public String getDescription() {
        return "Automatically internationalizes React applications by extracting hardcoded strings and replacing them with [react-i18next](https://react.i18next.com) translation calls. Handles JSX text, attributes, and template literals with variables. Creates and updates a translation JSON file with extracted strings.";
    }

    @Override
    protected List<String> getNpmCommand(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        String translationPath = this.translationFilePath != null ? this.translationFilePath : "translations.json";
        String rootKey = this.translationRoot != null ? this.translationRoot : "common";
        this.createDefaultTranslationsFile(acc, translationPath);
        ArrayList<String> command = new ArrayList<String>();
        command.add("node");
        command.add("${nodeModules}/jscodeshift/bin/jscodeshift.js");
        command.add("-t");
        command.add("${nodeModules}/jscodeshift-react-i18next/transform.ts");
        if (this.filePattern != null) {
            command.add("${repoDir}/" + this.filePattern);
        } else {
            command.add("${repoDir}");
        }
        if (this.parser != null) {
            command.add("--parser=" + this.parser);
        } else {
            command.add("--parser=${parser}");
        }
        command.add("--translationFilePath=" + translationPath);
        command.add("--importName=" + this.importName);
        command.add("--translationRoot=" + rootKey);
        return command;
    }

    @Override
    public Collection<? extends SourceFile> generate(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        Collection<? extends SourceFile> result = super.generate(acc, ctx);
        String translationPath = this.translationFilePath != null ? this.translationFilePath : "translations.json";
        Path translationFile = acc.getDirectory().resolve(translationPath);
        if (Files.exists(translationFile, new LinkOption[0])) {
            try {
                String content = new String(Files.readAllBytes(translationFile), StandardCharsets.UTF_8);
                PlainText translationSource = new PlainText(Tree.randomId(), Paths.get(translationPath, new String[0]), Markers.EMPTY, null, false, null, null, content, Collections.emptyList());
                ArrayList<Object> sources = new ArrayList<Object>();
                if (result != null) {
                    sources.addAll(result);
                }
                sources.add(translationSource);
                return sources;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read generated translation file: " + translationPath, e);
            }
        }
        return result;
    }

    private void createDefaultTranslationsFile(NodeBasedRecipe.Accumulator acc, String translationPath) {
        try {
            Path translationsFile = acc.getDirectory().resolve(translationPath);
            if (!Files.exists(translationsFile, new LinkOption[0])) {
                if (translationsFile.getParent() != null && !Files.exists(translationsFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(translationsFile.getParent(), new FileAttribute[0]);
                }
                String defaultTranslations = "{}";
                Files.write(translationsFile, defaultTranslations.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create default translations file: " + translationPath, e);
        }
    }

    @Generated
    public ReactI18Next(@Nullable String translationFilePath, String importName, @Nullable String translationRoot, @Nullable String filePattern, @Nullable String parser) {
        this.translationFilePath = translationFilePath;
        this.importName = importName;
        this.translationRoot = translationRoot;
        this.filePattern = filePattern;
        this.parser = parser;
    }

    @Generated
    public @Nullable String getTranslationFilePath() {
        return this.translationFilePath;
    }

    @Generated
    public String getImportName() {
        return this.importName;
    }

    @Generated
    public @Nullable String getTranslationRoot() {
        return this.translationRoot;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public @Nullable String getParser() {
        return this.parser;
    }

    @Generated
    public String toString() {
        return "ReactI18Next(translationFilePath=" + this.getTranslationFilePath() + ", importName=" + this.getImportName() + ", translationRoot=" + this.getTranslationRoot() + ", filePattern=" + this.getFilePattern() + ", parser=" + this.getParser() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactI18Next)) {
            return false;
        }
        ReactI18Next other = (ReactI18Next)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$translationFilePath = this.getTranslationFilePath();
        String other$translationFilePath = other.getTranslationFilePath();
        if (this$translationFilePath == null ? other$translationFilePath != null : !this$translationFilePath.equals(other$translationFilePath)) {
            return false;
        }
        String this$importName = this.getImportName();
        String other$importName = other.getImportName();
        if (this$importName == null ? other$importName != null : !this$importName.equals(other$importName)) {
            return false;
        }
        String this$translationRoot = this.getTranslationRoot();
        String other$translationRoot = other.getTranslationRoot();
        if (this$translationRoot == null ? other$translationRoot != null : !this$translationRoot.equals(other$translationRoot)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        String this$parser = this.getParser();
        String other$parser = other.getParser();
        return !(this$parser == null ? other$parser != null : !this$parser.equals(other$parser));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReactI18Next;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $translationFilePath = this.getTranslationFilePath();
        result = result * 59 + ($translationFilePath == null ? 43 : $translationFilePath.hashCode());
        String $importName = this.getImportName();
        result = result * 59 + ($importName == null ? 43 : $importName.hashCode());
        String $translationRoot = this.getTranslationRoot();
        result = result * 59 + ($translationRoot == null ? 43 : $translationRoot.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        String $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        return result;
    }
}

