export * from '@babel/parser';
import { Node } from '@babel/types';
import * as types from '@babel/types';
export { types };
export { traverse } from '@babel/types';

interface Location {
    start: {
        line: number;
        column: number;
    };
}

interface CodeFrameOptions {}

interface TemplateOptions {}

declare function codeFrameColumns(rawLines: string, location: Location, options: CodeFrameOptions): string;
declare function ast(source: string): Node;
declare function generate(ast: Node): string;
declare function template(source: string, options?: TemplateOptions): string;
declare namespace template {
    export { ast };
}

export { codeFrameColumns, generate, template };
