import ts from "typescript";
import { ChangeAction } from "../../../utils/textChanges.js";
import { PositionInfo } from "../../LinterContext.js";
import Fix from "./Fix.js";
export interface GlobalFixParams {
    moduleName: string;
    propertyAccessStack: string[];
    resourcePath: string;
}
/**
 * Fix a global property access. Requires a module name which will be imported and replaces the defined property access.
 * The property access is in the order of the AST, e.g. ["core", "ui", "sap"]
 */
export default class GlobalFix extends Fix {
    private params;
    private startPos;
    private endPos;
    private moduleIdentifier;
    private sourcePosition;
    private isConditional;
    constructor(params: GlobalFixParams);
    visitLinterNode(node: ts.Node, sourcePosition: PositionInfo): boolean;
    getNodeSearchParameters(): {
        nodeTypes: ts.SyntaxKind[];
        position: PositionInfo;
    };
    visitAutofixNode(node: ts.Node, position: number, sourceFile: ts.SourceFile): boolean;
    getAffectedSourceCodeRange(): {
        start: number;
        end: number;
    };
    setIdentifierForDependency(identifier: string): void;
    getNewModuleDependencies(): {
        moduleName: string;
        usagePosition: number;
        blockNewImport: boolean | undefined;
    } | undefined;
    getNewGlobalAccess(): undefined;
    setIdentifierForGlobal(): void;
    generateChanges(): {
        action: ChangeAction;
        start: number;
        end: number;
        value: string;
    } | undefined;
}
