import ts from "typescript";
import { Ui5TypeInfoKind } from "./Ui5TypeInfo.js";
export default function getJqueryTypeInfo(node) {
    if (!ts.isPropertyAccessExpression(node) && !ts.isElementAccessExpression(node)) {
        // Only PropertyAccessExpressions are supported for jQuery fixes
        return;
    }
    const parts = [];
    let scanNode = node;
    // Apart from creating the "mocked" UI5 Type Info, we also need to determine the relevant node
    // since the input node will always be "jQuery" or "jQuery.sap"
    let relevantNode = node;
    // Determine access chain
    // Input node is always something like "jQuery.sap"
    // So we need to search the parents to get the full access chain like "jQuery.sap.log.LogLevel"
    while (ts.isPropertyAccessExpression(scanNode)) {
        if (!ts.isIdentifier(scanNode.name)) {
            throw new Error(`Unexpected PropertyAccessExpression node: Expected name to be identifier but got ` +
                ts.SyntaxKind[scanNode.name.kind]);
        }
        parts.push(scanNode.name.text);
        relevantNode = scanNode;
        scanNode = scanNode.parent;
    }
    const moduleType = {
        kind: Ui5TypeInfoKind.Module,
        name: "jQuery",
        library: "jquery",
    };
    let mockedTypeInfo;
    for (const part of parts) {
        const newTypeInfo = {
            kind: Ui5TypeInfoKind.Namespace,
            name: part,
        };
        if (mockedTypeInfo) {
            newTypeInfo.parent = mockedTypeInfo;
        }
        else {
            newTypeInfo.parent = moduleType;
        }
        mockedTypeInfo = newTypeInfo;
    }
    // At this point, relevantNode is always an access expression
    // However, some fixes require access to the full call expression. Therefore check
    // whether this access expression is part of a call expression and if so, return the call expression
    if (ts.isCallExpression(scanNode) && scanNode.expression === relevantNode) {
        relevantNode = scanNode;
    }
    return {
        ui5TypeInfo: mockedTypeInfo ?? moduleType,
        node: relevantNode,
    };
}
//# sourceMappingURL=getJqueryTypeInfo.js.map