import { ChangeAction } from "../../../utils/textChanges.js";
import { HtmlFix } from "./HtmlFix.js";
/**
 * Special fix to change the animation mode attribute in HTML tags.
 * @param attribute The animation mode attribute to be fixed.
 */
export default class AnimationModeFix extends HtmlFix {
    nameStartPositionDetail;
    nameEndPositionDetail;
    valueStartPositionDetail;
    valueEndPositionDetail;
    oldValue;
    nameStartPos;
    nameEndPos;
    valueStartPos;
    valueEndPos;
    constructor(attribute) {
        super();
        this.nameStartPositionDetail = attribute.name.start;
        this.nameEndPositionDetail = attribute.name.end;
        this.valueStartPositionDetail = attribute.value.start;
        this.valueEndPositionDetail = attribute.value.end;
        this.oldValue = attribute.value.value;
    }
    calculateSourceCodeRange(toPosition) {
        this.nameStartPos = toPosition(this.nameStartPositionDetail);
        this.nameEndPos = toPosition(this.nameEndPositionDetail);
        this.valueStartPos = toPosition(this.valueStartPositionDetail);
        this.valueEndPos = toPosition(this.valueEndPositionDetail);
        // We need to provide the overall range of our change so that the autofix
        // can check for conflicts with outer fixes.
        // The actual changes will be defined in the generateChanges method.
        this.startPos = this.nameStartPos;
        this.endPos = this.valueEndPos;
    }
    generateChanges() {
        if (this.nameStartPos === undefined || this.nameEndPos === undefined ||
            this.valueStartPos === undefined || this.valueEndPos === undefined) {
            throw new Error("Required positions are not defined");
        }
        // This will replace the legacy attribute name
        // to "data-sap-ui-animation-mode":
        const nameChange = {
            action: ChangeAction.REPLACE,
            start: this.nameStartPos,
            end: this.nameEndPos,
            value: "data-sap-ui-animation-mode",
        };
        // This will replace the value of the animation mode attribute
        // to "full" or "minimal" based on the old value:
        const newValue = AnimationModeFix.getAnimationModeValue(this.oldValue);
        const valueChange = {
            action: ChangeAction.REPLACE,
            start: this.valueStartPos,
            end: this.valueEndPos,
            value: newValue,
        };
        return [nameChange, valueChange];
    }
    static getAnimationModeValue(animationValue) {
        const lowerCaseValue = animationValue.toLowerCase();
        return lowerCaseValue === "true" || lowerCaseValue === "x" ? "full" : "minimal";
    }
}
//# sourceMappingURL=AnimationModeFix.js.map