// For Library Version: 1.120.0

declare module "sap/collaboration/library" {
  /**
   * Application Type (Mode)
   */
  export enum AppType {
    /**
     * Fiori Split App
     */
    split = "split",
    /**
     * SAP Jam Feed Widget Wrapper
     */
    widget = "widget",
  }
  /**
   * Feed Types to be displayed by the Social Timeline
   */
  export enum DisplayFeedType {
    /**
     * The main feed for the Business Record Feed
     */
    BusinessRecordFeed = "BusinessRecordFeed",
    /**
     * Group feeds where the business record is primary or featured
     */
    GroupFeedsWhereBusinessRecordIsLinked = "GroupFeedsWhereBusinessRecordIsLinked",
  }
  /**
   * Feed Types
   */
  export enum FeedType {
    /**
     * The mode type that accepts the OData details of a business object. Users will be able to select groups
     * where the business object is featured or primary.
     */
    BusinessObjectGroups = "BusinessObjectGroups",
    /**
     * @deprecated (since 1.30.0) - The feed type was deprecated because the original feed dialog component
     * does not use it anymore. It also does not conform to naming conventions.
     *
     * Company feed type
     */
    company = "company",
    /**
     * @deprecated (since 1.30.0) - The feed type was deprecated because the original feed dialog component
     * does not use it anymore. It also does not conform to naming conventions.
     *
     * Follows feed type
     */
    follows = "follows",
    /**
     * @deprecated (since 1.30.0) - The feed type was deprecated because the original feed dialog component
     * does not use it anymore. It also does not conform to naming conventions.
     *
     * Group feed type
     */
    group = "group",
    /**
     * The mode type that accepts an array of group IDs. Users will be able to select these groups from a selector.
     * The list will have the groups' names.
     */
    GroupIds = "GroupIds",
    /**
     * @deprecated (since 1.30.0) - The feed type was deprecated because the original feed dialog component
     * does not use it anymore. It also does not conform to naming conventions.
     *
     * Oject feed type
     */
    object = "object",
    /**
     * @deprecated (since 1.30.0) - The feed type was deprecated because the original feed dialog component
     * does not use it anymore. It also does not conform to naming conventions.
     *
     * Object group feed type
     */
    objectGroup = "objectGroup",
    /**
     * Users of this mode type will be able to select from groups where they are members. This mode is used
     * by the feed component. In the feed component, the list of groups displayed in the pop up will be the
     * current user's personal groups.
     */
    UserGroups = "UserGroups",
  }
}

declare module "sap/collaboration/components/feed/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { ID } from "sap/ui/core/library";

  import { TimelineAxisOrientation } from "sap/suite/ui/commons/library";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * @since 1.30
   *
   * The Feed Component is an SAPUI5 component that allows you to display SAP Jam feeds. It includes the option
   * to add new posts and reply to entries and view other users' social profiles from SAP Jam.
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the Feed Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new component. See the documentation of the component's properties for the structure
       * of the expected data.
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the Feed Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new component, generated automatically if no id is given
       */
      sId?: ID,
      /**
       * initial settings for the new component. See the documentation of the component's properties for the structure
       * of the expected data.
       */
      mSettings?: $ComponentSettings
    );

    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * The method to create the Content (UI Control Tree) of the Component.
     */
    static createContent(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Cleans up the component instance before destruction.
     */
    static exit(): void;
    /**
     * Creates a new subclass of class sap.collaboration.components.feed.Component with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.feed.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * Returns the selected Group.
     *
     * @returns a map containing information about the selected Group (e.g. Id, Name, etc...)
     */
    static getSelectedGroup(): Record<string, any>;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Initializes the Component instance after creation.
     */
    static init(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Function is called when the rendering of the Component Container is completed.
     */
    static onAfterRendering(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Function is called when the rendering of the Component Container is started.
     */
    static onBeforeRendering(): void;
    /**
     * Set the axis orientation for the Timeline.
     */
    static setAxisOrientation(
      axisOrientation:
        | TimelineAxisOrientation
        | keyof typeof TimelineAxisOrientation
    ): void;
    /**
     * Sets the enableScroll property for the Timeline.
     */
    static setEnableScroll(enableScroll: boolean): void;
    /**
     * Sets the sources for the feed. Array of strings representing the Jam group IDs (e.g. ["groupid1", "groupid2"]).
     */
    static setFeedSources(feedSources: object): void;
    /**
     * Sets all the properties passed in oSettings.
     */
    static setSettings(
      /**
       * key/value map for settings
       */
      settings: Record<string, any>
    ): void;
    /**
     * Getter for property `axisOrientation`.
     *
     * Default value is `Vertical`
     *
     * @returns the value of property `axisOrientation`
     */
    getAxisOrientation():
      | TimelineAxisOrientation
      | keyof typeof TimelineAxisOrientation;
    /**
     * Getter for property `enableScroll`.
     *
     * @returns the value of property `enableScroll`
     */
    getEnableScroll(): boolean;
    /**
     * Getter for property `feedSources`.
     *
     * @returns the value of property `feedSources`
     */
    getFeedSources(): Record<string, any> | string[];
    /**
     * Setter for property `axisOrientation`.
     *
     * Default value is `Vertical`
     *
     * @returns `this` to allow method chaining
     */
    setAxisOrientation(
      /**
       * new value for property `axisOrientation`
       */
      oAxisOrientation:
        | TimelineAxisOrientation
        | keyof typeof TimelineAxisOrientation
    ): this;
    /**
     * Setter for property `enableScroll`.
     *
     * Sets the property enableScroll on the Timeline.
     *
     * Setting this property to false will remove the scrollbar on the Timeline.
     *
     *
     * Default value is `true`
     *
     * @returns `this` to allow method chaining
     */
    setEnableScroll(
      /**
       * new value for property `enableScroll`
       */
      bEnableScroll: boolean
    ): this;
    /**
     * Setter for property `feedSources`.
     *
     * The feedSources is either an array of strings (SAP Jam Group IDs) or a map in the following structure:
     *  { mode : sap.collaboration.FeedType, data : any }
     *  Based on the mode, the data is either required or not.
     *
     * @returns `this` to allow method chaining
     */
    setFeedSources(
      /**
       * new value for property `feedSources`
       */
      oFeedSources: Record<string, any> | string[]
    ): this;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    axisOrientation?:
      | (TimelineAxisOrientation | keyof typeof TimelineAxisOrientation)
      | PropertyBindingInfo
      | `{${string}}`;

    feedSources?: object | string[] | PropertyBindingInfo | `{${string}}`;

    enableScroll?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/collaboration/components/fiori/feed/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { CSSSize, URI } from "sap/ui/core/library";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * @deprecated (since 1.26.0) - Please use sap.collaboration.components.fiori.feed.dialog.Component instead.
   *
   * Feed Component
   *
   *
   * A Feed Component is a ui5 component that applications can use to render a sap.m.App that embeds
   * the JAM Feed Widget.
   *  The Component class extends the base UI5 UIComponent class.
   *  This class defines the Reusable UI5 Component structure, i.e properties, aggregations and events, if
   * any, and creates the UI5 controls to be displayed.
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the Feed Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new component instance
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the Feed Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new component
       */
      sId?: string,
      /**
       * Initial settings for the new component instance
       */
      mSettings?: $ComponentSettings
    );

    /**
     * Creates a new subclass of class sap.collaboration.components.fiori.feed.Component with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.fiori.feed.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * Gets current value of property {@link #getFeedType feedType}.
     *
     * The type of feed to be displayed. The available types are in @link sap.collaboration.FeedType.
     *
     * @returns Value of property `feedType`
     */
    getFeedType(): string;
    /**
     * Gets current value of property {@link #getGroupIds groupIds}.
     *
     * A comma separated list of the IDs of the groups to display in the widget.
     *
     * @returns Value of property `groupIds`
     */
    getGroupIds(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the component.
     *
     * Default value is `empty string`.
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getObject object}.
     *
     * A JSON object passed to the Feed component.
     *
     * It is required when the value of feedType is sap.collaboration.FeedType.object or sap.collaboration.FeedType.objectGroup.
     * This object represents business related information, such as a sales order, an opportunity, etc. It contains
     * the following properties:
     * 	 - **id**: The Business Object ID to be posted in the SAP Jam Feed. It needs to be an OData
     *     URL containing the relative path to the object in the back-end.
     * 	 - **type**: The type of the Business Object. It needs to be the OData meta data URL to the
     *     corresponding Entity Collection.
     * 	 - **name?** (optional): The description of the Business Object to be displayed in SAP Jam,
     *     i.e. "SO 57746", "Opportunity 123", etc.
     * 	 - **ui_url?** (optional): The URL to navigate to the same Business Object in the application.
     *
     *
     * @returns Value of property `object`
     */
    getObject(): object;
    /**
     * Gets current value of property {@link #getODataServiceUrl oDataServiceUrl}.
     *
     * The OData service URL needed for the Feed Component.
     *
     * Default value is `"/sap/opu/odata/sap/SM_INTEGRATION_SRV"`.
     *
     * @returns Value of property `oDataServiceUrl`
     */
    getODataServiceUrl(): URI;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the component.
     *
     * Default value is `empty string`.
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getFeedType feedType}.
     *
     * The type of feed to be displayed. The available types are in @link sap.collaboration.FeedType.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFeedType(
      /**
       * New value for property `feedType`
       */
      sFeedType: string
    ): this;
    /**
     * Sets a new value for property {@link #getGroupIds groupIds}.
     *
     * A comma separated list of the IDs of the groups to display in the widget.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGroupIds(
      /**
       * New value for property `groupIds`
       */
      sGroupIds: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getObject object}.
     *
     * A JSON object passed to the Feed component.
     *
     * It is required when the value of feedType is sap.collaboration.FeedType.object or sap.collaboration.FeedType.objectGroup.
     * This object represents business related information, such as a sales order, an opportunity, etc. It contains
     * the following properties:
     * 	 - **id**: The Business Object ID to be posted in the SAP Jam Feed. It needs to be an OData
     *     URL containing the relative path to the object in the back-end.
     * 	 - **type**: The type of the Business Object. It needs to be the OData meta data URL to the
     *     corresponding Entity Collection.
     * 	 - **name?** (optional): The description of the Business Object to be displayed in SAP Jam,
     *     i.e. "SO 57746", "Opportunity 123", etc.
     * 	 - **ui_url?** (optional): The URL to navigate to the same Business Object in the application.
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObject(
      /**
       * New value for property `object`
       */
      oObject: object
    ): this;
    /**
     * Sets a new value for property {@link #getODataServiceUrl oDataServiceUrl}.
     *
     * The OData service URL needed for the Feed Component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"/sap/opu/odata/sap/SM_INTEGRATION_SRV"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setODataServiceUrl(
      /**
       * New value for property `oDataServiceUrl`
       */
      sODataServiceUrl?: URI
    ): this;
    /**
     * Contract for passing the settings to the Component.
     */
    setSettings(
      /**
       * A JSON object containing the following attributes:
       * 	 - {sap.ui.core.URI} oDataServiceUrl: The URL of the OData Service needed for the Feed Component.
       *
       * 	 - {sap.collaboration.FeedType} feedType: The type of feed to be displayed.
       * 	 - {string} [groupIds?]: A comma separated list of Group IDs.
       * 	 - {object} object: The representation of a Business Object.
       */
      oSettings: object
    ): void;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    /**
     * The width of the component.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the component.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The OData service URL needed for the Feed Component.
     */
    oDataServiceUrl?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * The type of feed to be displayed. The available types are in @link sap.collaboration.FeedType.
     */
    feedType?: string | PropertyBindingInfo;

    /**
     * A comma separated list of the IDs of the groups to display in the widget.
     */
    groupIds?: string | PropertyBindingInfo;

    /**
     * A JSON object passed to the Feed component.
     *
     * It is required when the value of feedType is sap.collaboration.FeedType.object or sap.collaboration.FeedType.objectGroup.
     * This object represents business related information, such as a sales order, an opportunity, etc. It contains
     * the following properties:
     * 	 - **id**: The Business Object ID to be posted in the SAP Jam Feed. It needs to be an OData
     *     URL containing the relative path to the object in the back-end.
     * 	 - **type**: The type of the Business Object. It needs to be the OData meta data URL to the
     *     corresponding Entity Collection.
     * 	 - **name?** (optional): The description of the Business Object to be displayed in SAP Jam,
     *     i.e. "SO 57746", "Opportunity 123", etc.
     * 	 - **ui_url?** (optional): The URL to navigate to the same Business Object in the application.
     */
    object?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/collaboration/components/fiori/feed/dialog/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { CSSSize } from "sap/ui/core/library";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * @deprecated (since 1.34.0) - For new integrations and existing implementations running on release 1.32
   * or later, use the Group Feed component (sap.collaboration.components.feed.Component), Business Object
   * mode(sap.collaboration.FeedType.BusinessObjectGroups). Note that the Group Feed component does not display
   * the full public feed for the object in SAP Jam (object wall), but rather is restricted to the feed for
   * the object within a specific group (group object wall).
   *
   * Feed Dialog Component
   *
   * A Feed Dialog Component is a ui5 component that applications can use to render the feed widget view in
   * a dialog in order to discuss information in SAP JAM by adding and replying to feed posts related to a
   * specific Business Object.
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the Feed Dialog Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the Feed Dialog Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );

    /**
     * Creates a new subclass of class sap.collaboration.components.fiori.feed.dialog.Component with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.fiori.feed.dialog.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * Gets current value of property {@link #getBusinessObject businessObject}.
     *
     * A JSON object passed to the Feed Dialog Component. This object represents business related information,
     * such as a sales order, an opportunity, etc. It contains the following properties:
     * 	 - {string} appContext: The application context. Example: "CRM", "CB", "SD", etc.
     * 	 - {string} odataServicePath: The path to the OData Service and the Service name. Example:
     *     "/sap/opu/odata/sap/APPLICATION_SRV".
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity",
     *     etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be
     *     a simple ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'",
     *     etc.
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity
     *     123", "Account 123", etc.
     * 	 - {string} ui_url: The URL to navigate to the same business object in the application.
     *
     * @returns Value of property `businessObject`
     */
    getBusinessObject(): object;
    /**
     * Gets current value of property {@link #getFeedType feedType}.
     *
     * **[DEPRECATED]** The type of feed to be displayed.
     *
     * The available types are in @link sap.collaboration.FeedType.
     *
     * Default value is `FeedType.object`.
     *
     * @returns Value of property `feedType`
     */
    getFeedType(): string;
    /**
     * Gets current value of property {@link #getGroupIds groupIds}.
     *
     * **[DEPRECATED]** The IDs of the group to display in the widget.
     *
     * @returns Value of property `groupIds`
     */
    getGroupIds(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the component.
     *
     * We need to pass a value in pixels, otherwise the dialog won't render correctly
     *
     * Default value is `"605px"`.
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getObject object}.
     *
     * **[DEPRECATED]** A JSON object passed to the Feed Dialog Component. Use **businessObject** instead.
     * This object represents business related information, such as a sales order, an opportunity, etc. It contains
     * the following properties:
     * 	 - id: The Business Object ID to be posted in the SAP Jam Feed. It needs to be an OData URL
     *     containing the relative path to the object in the back-end.
     * 	 - type: the type of the business object. It can be any text or it can be the OData meta data
     *     URL to the object Entity Type.
     * 	 - name (optional): the description of the business object to be displayed in SAP Jam, i.e.
     *     "SO 57746", "Opportunity 123", etc.
     * 	 - ui_url (optional): the URL to navigate to the same business object in the application.
     *     Note: The object is passed by reference, which means that the attributes will be modified in the original
     *     object, for example, when the URLs contained in the id and type attributes are mapped (via OData call).
     *
     * @returns Value of property `object`
     */
    getObject(): object;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the component.
     *
     * Default value is `"575px"`.
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Open the Feed Dialog.
     */
    open(): void;
    /**
     * Sets a new value for property {@link #getBusinessObject businessObject}.
     *
     * A JSON object passed to the Feed Dialog Component. This object represents business related information,
     * such as a sales order, an opportunity, etc. It contains the following properties:
     * 	 - {string} appContext: The application context. Example: "CRM", "CB", "SD", etc.
     * 	 - {string} odataServicePath: The path to the OData Service and the Service name. Example:
     *     "/sap/opu/odata/sap/APPLICATION_SRV".
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity",
     *     etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be
     *     a simple ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'",
     *     etc.
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity
     *     123", "Account 123", etc.
     * 	 - {string} ui_url: The URL to navigate to the same business object in the application.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBusinessObject(
      /**
       * New value for property `businessObject`
       */
      oBusinessObject: object
    ): this;
    /**
     * Sets a new value for property {@link #getFeedType feedType}.
     *
     * **[DEPRECATED]** The type of feed to be displayed.
     *
     * The available types are in @link sap.collaboration.FeedType.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `FeedType.object`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFeedType(
      /**
       * New value for property `feedType`
       */
      sFeedType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getGroupIds groupIds}.
     *
     * **[DEPRECATED]** The IDs of the group to display in the widget.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGroupIds(
      /**
       * New value for property `groupIds`
       */
      sGroupIds: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the component.
     *
     * We need to pass a value in pixels, otherwise the dialog won't render correctly
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"605px"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getObject object}.
     *
     * **[DEPRECATED]** A JSON object passed to the Feed Dialog Component. Use **businessObject** instead.
     * This object represents business related information, such as a sales order, an opportunity, etc. It contains
     * the following properties:
     * 	 - id: The Business Object ID to be posted in the SAP Jam Feed. It needs to be an OData URL
     *     containing the relative path to the object in the back-end.
     * 	 - type: the type of the business object. It can be any text or it can be the OData meta data
     *     URL to the object Entity Type.
     * 	 - name (optional): the description of the business object to be displayed in SAP Jam, i.e.
     *     "SO 57746", "Opportunity 123", etc.
     * 	 - ui_url (optional): the URL to navigate to the same business object in the application.
     *     Note: The object is passed by reference, which means that the attributes will be modified in the original
     *     object, for example, when the URLs contained in the id and type attributes are mapped (via OData call).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObject(
      /**
       * New value for property `object`
       */
      oObject: object
    ): this;
    /**
     * Contract for passing the settings to the Component.
     */
    setSettings(
      /**
       * A JSON object containing the following attributes:
       * 	 - {object} businessObject: the representation of a business object.
       * 	 - {sap.collaboration.FeedType} **[DEPRECATED]** feedType: the type of feed to be displayed.
       *
       * 	 - {string} **[DEPRECATED]** [groupIds?]: a comma separated list of group IDs.
       * 	 - {object} **[DEPRECATED]** object: the representation of a business object. Use businessObject
       *     instead
       */
      oSettings: object
    ): void;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"575px"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    /**
     * The width of the component.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the component.
     *
     * We need to pass a value in pixels, otherwise the dialog won't render correctly
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * **[DEPRECATED]** The type of feed to be displayed.
     *
     * The available types are in @link sap.collaboration.FeedType.
     */
    feedType?: string | PropertyBindingInfo;

    /**
     * **[DEPRECATED]** The IDs of the group to display in the widget.
     */
    groupIds?: string | PropertyBindingInfo;

    /**
     * **[DEPRECATED]** A JSON object passed to the Feed Dialog Component. Use **businessObject** instead.
     * This object represents business related information, such as a sales order, an opportunity, etc. It contains
     * the following properties:
     * 	 - id: The Business Object ID to be posted in the SAP Jam Feed. It needs to be an OData URL
     *     containing the relative path to the object in the back-end.
     * 	 - type: the type of the business object. It can be any text or it can be the OData meta data
     *     URL to the object Entity Type.
     * 	 - name (optional): the description of the business object to be displayed in SAP Jam, i.e.
     *     "SO 57746", "Opportunity 123", etc.
     * 	 - ui_url (optional): the URL to navigate to the same business object in the application.
     *     Note: The object is passed by reference, which means that the attributes will be modified in the original
     *     object, for example, when the URLs contained in the id and type attributes are mapped (via OData call).
     */
    object?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * A JSON object passed to the Feed Dialog Component. This object represents business related information,
     * such as a sales order, an opportunity, etc. It contains the following properties:
     * 	 - {string} appContext: The application context. Example: "CRM", "CB", "SD", etc.
     * 	 - {string} odataServicePath: The path to the OData Service and the Service name. Example:
     *     "/sap/opu/odata/sap/APPLICATION_SRV".
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity",
     *     etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be
     *     a simple ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'",
     *     etc.
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity
     *     123", "Account 123", etc.
     * 	 - {string} ui_url: The URL to navigate to the same business object in the application.
     */
    businessObject?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/collaboration/components/fiori/notification/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { URI } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * @deprecated (since 1.26.0) - There is no replacement for this control. The Fiori Launchpad now provides
   * its own implementation for this control. This control was never meant to be used directly by third parties.
   *
   * Notification Component
   *
   * A Notification Component is a UI5 component that displays a SAP Jam member's latest notifications.
   *
   * This component refreshes itself when the number of seconds specified in the refreshInterval
   * parameter elapses. When refreshing, the backend is called to obtain the latest notifications.
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the notification component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new component instance
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the notification component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new component
       */
      sId?: string,
      /**
       * Initial settings for the new component instance
       */
      mSettings?: $ComponentSettings
    );

    /**
     * Creates a new subclass of class sap.collaboration.components.fiori.notification.Component with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.fiori.notification.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * Gets current value of property {@link #getNotificationsTargetUrl notificationsTargetUrl}.
     *
     * When a user clicks on the component, a new browser tab will open at this URL.
     *
     * @returns Value of property `notificationsTargetUrl`
     */
    getNotificationsTargetUrl(): URI;
    /**
     * Gets current value of property {@link #getNumberOfNotifications numberOfNotifications}.
     *
     * The maximum number of notifications to be displayed.
     *
     * Default value is `10`.
     *
     * @returns Value of property `numberOfNotifications`
     */
    getNumberOfNotifications(): int;
    /**
     * Gets current value of property {@link #getODataServiceUrl oDataServiceUrl}.
     *
     * The OData service URL needed for the notification component.
     *
     * Default value is `"/sap/opu/odata/sap/SM_INTEGRATION_SRV"`.
     *
     * @returns Value of property `oDataServiceUrl`
     */
    getODataServiceUrl(): URI;
    /**
     * Gets current value of property {@link #getRefreshInterval refreshInterval}.
     *
     * The time in seconds before calling the backend to update the notifications.
     *
     * Default value is `300`.
     *
     * @returns Value of property `refreshInterval`
     */
    getRefreshInterval(): int;
    /**
     * Gets current value of property {@link #getTransitionInterval transitionInterval}.
     *
     * The time in seconds a notification is displayed before the next notification is displayed.
     *
     * Default value is `10`.
     *
     * @returns Value of property `transitionInterval`
     */
    getTransitionInterval(): int;
    /**
     * Sets a new value for property {@link #getNotificationsTargetUrl notificationsTargetUrl}.
     *
     * When a user clicks on the component, a new browser tab will open at this URL.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNotificationsTargetUrl(
      /**
       * New value for property `notificationsTargetUrl`
       */
      sNotificationsTargetUrl: URI
    ): this;
    /**
     * Sets a new value for property {@link #getNumberOfNotifications numberOfNotifications}.
     *
     * The maximum number of notifications to be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNumberOfNotifications(
      /**
       * New value for property `numberOfNotifications`
       */
      iNumberOfNotifications?: int
    ): this;
    /**
     * Sets a new value for property {@link #getODataServiceUrl oDataServiceUrl}.
     *
     * The OData service URL needed for the notification component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"/sap/opu/odata/sap/SM_INTEGRATION_SRV"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setODataServiceUrl(
      /**
       * New value for property `oDataServiceUrl`
       */
      sODataServiceUrl?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getRefreshInterval refreshInterval}.
     *
     * The time in seconds before calling the backend to update the notifications.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `300`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRefreshInterval(
      /**
       * New value for property `refreshInterval`
       */
      iRefreshInterval?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTransitionInterval transitionInterval}.
     *
     * The time in seconds a notification is displayed before the next notification is displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTransitionInterval(
      /**
       * New value for property `transitionInterval`
       */
      iTransitionInterval?: int
    ): this;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    /**
     * The OData service URL needed for the notification component.
     */
    oDataServiceUrl?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * The maximum number of notifications to be displayed.
     */
    numberOfNotifications?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The time in seconds a notification is displayed before the next notification is displayed.
     */
    transitionInterval?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The time in seconds before calling the backend to update the notifications.
     */
    refreshInterval?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * When a user clicks on the component, a new browser tab will open at this URL.
     */
    notificationsTargetUrl?: URI | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/collaboration/components/fiori/sharing/attachment/Attachment" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Attachment
   *
   * Attachment objects represent files.
   */
  export default class Attachment extends BaseObject {
    /**
     * This constructor must be called in the following way: new Attachment("name", "mimeType", "url")
     * name, mimeType, and url are only place holders and can be any string.
     */
    constructor(
      /**
       * The file's name.
       */
      name: string,
      /**
       * The file's mime type.
       */
      mimeType: string,
      /**
       * A url that points to the file.
       */
      url: string
    );

    /**
     * Creates a new subclass of class sap.collaboration.components.fiori.sharing.attachment.Attachment with
     * name `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Attachment>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.fiori.sharing.attachment.Attachment.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/collaboration/components/fiori/sharing/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { URI, CSSSize } from "sap/ui/core/library";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * @deprecated (since 1.26.0) - Please use sap.collaboration.components.fiori.sharing.dialog.Component instead.
   *
   * Share Component
   *
   * A Share Component is a ui5 component that applications can use to share information to SAP Jam
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the share component
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the share component
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );

    /**
     * Creates a new subclass of class sap.collaboration.components.fiori.sharing.Component with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.fiori.sharing.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * Gets current value of property {@link #getAttachments attachments}.
     *
     * @returns Value of property `attachments`
     */
    getAttachments(): object;
    /**
     * Gets current value of property {@link #getCollaborationHostODataServiceUrl collaborationHostODataServiceUrl}.
     *
     * Default value is `"/sap/bc/ui2/smi/rest_tunnel/Jam/api/v1/OData"`.
     *
     * @returns Value of property `collaborationHostODataServiceUrl`
     */
    getCollaborationHostODataServiceUrl(): URI;
    /**
     * Gets current value of property {@link #getExternalObject externalObject}.
     *
     * A Business Object such as an Opportunity, Sales Order, Account, etc. from the back-end that will be shared
     * as a Featured External Object in a Group in Jam.
     * 	 - {string} appContext: The application context. Example: "CRM", "SD", etc.
     * 	 - {string} odataServicePath: The relative path to the OData Service. Example: "/sap/opu/odata/sap/ODATA_SRV"
     *
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity", etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be a simple
     *     ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'", etc.
     *
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity 123",
     *     "Account 123", etc.   These attributes are not enforced by the UI (missing or incorrect values
     *     are not validated), but they are required to make the integration work. These attributes also should
     *     be mapped in the Back-end System and Jam in order to make the External Object work.
     * **Note:** the externalObject is dependent on object.id, therefore, the object.id must also be passed
     * to the Share Component. See the parameter "object" for more information.
     *
     * @returns Value of property `externalObject`
     */
    getExternalObject(): object;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Default value is `"100%"`.
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getObject object}.
     *
     * A JSON object passed to the share component. This object contains the following properties:
     * 	 - id (optional): is the object Id to be shared in SAP Jam, i.e a URL that navigates back to the same
     *     object in the application
     * 	 - display (optional): is a UI5 control to be displayed in the component UI
     * 	 - share (optional): is a note that will be displayed in the component UI and shared to SAP Jam too
     *
     *
     * @returns Value of property `object`
     */
    getObject(): object;
    /**
     * Gets current value of property {@link #getODataServiceUrl oDataServiceUrl}.
     *
     * The OData service URL needed for the share component.
     *
     * Default value is `"/sap/opu/odata/sap/SM_INTEGRATION_V2_SRV"`.
     *
     * @returns Value of property `oDataServiceUrl`
     */
    getODataServiceUrl(): URI;
    /**
     * Gets current value of property {@link #getTunnelServiceUrl tunnelServiceUrl}.
     *
     * Default value is `"/sap/bc/z_sail_httproxy/Jam/api/v1/OData"`.
     *
     * @returns Value of property `tunnelServiceUrl`
     */
    getTunnelServiceUrl(): URI;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Default value is `"100%"`.
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getAttachments attachments}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAttachments(
      /**
       * New value for property `attachments`
       */
      oAttachments: object
    ): this;
    /**
     * Sets a new value for property {@link #getCollaborationHostODataServiceUrl collaborationHostODataServiceUrl}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"/sap/bc/ui2/smi/rest_tunnel/Jam/api/v1/OData"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCollaborationHostODataServiceUrl(
      /**
       * New value for property `collaborationHostODataServiceUrl`
       */
      sCollaborationHostODataServiceUrl?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getExternalObject externalObject}.
     *
     * A Business Object such as an Opportunity, Sales Order, Account, etc. from the back-end that will be shared
     * as a Featured External Object in a Group in Jam.
     * 	 - {string} appContext: The application context. Example: "CRM", "SD", etc.
     * 	 - {string} odataServicePath: The relative path to the OData Service. Example: "/sap/opu/odata/sap/ODATA_SRV"
     *
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity", etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be a simple
     *     ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'", etc.
     *
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity 123",
     *     "Account 123", etc.   These attributes are not enforced by the UI (missing or incorrect values
     *     are not validated), but they are required to make the integration work. These attributes also should
     *     be mapped in the Back-end System and Jam in order to make the External Object work.
     * **Note:** the externalObject is dependent on object.id, therefore, the object.id must also be passed
     * to the Share Component. See the parameter "object" for more information.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExternalObject(
      /**
       * New value for property `externalObject`
       */
      oExternalObject: object
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getObject object}.
     *
     * A JSON object passed to the share component. This object contains the following properties:
     * 	 - id (optional): is the object Id to be shared in SAP Jam, i.e a URL that navigates back to the same
     *     object in the application
     * 	 - display (optional): is a UI5 control to be displayed in the component UI
     * 	 - share (optional): is a note that will be displayed in the component UI and shared to SAP Jam too
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObject(
      /**
       * New value for property `object`
       */
      oObject: object
    ): this;
    /**
     * Sets a new value for property {@link #getODataServiceUrl oDataServiceUrl}.
     *
     * The OData service URL needed for the share component.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"/sap/opu/odata/sap/SM_INTEGRATION_V2_SRV"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setODataServiceUrl(
      /**
       * New value for property `oDataServiceUrl`
       */
      sODataServiceUrl?: URI
    ): this;
    /**
     * Setter for the Component settings.
     */
    setSettings(
      /**
       * A JSON object used to set the component settings, this object should contains the same properties used
       * in the constructor.
       */
      oSettings: object
    ): void;
    /**
     * Sets a new value for property {@link #getTunnelServiceUrl tunnelServiceUrl}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"/sap/bc/z_sail_httproxy/Jam/api/v1/OData"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTunnelServiceUrl(
      /**
       * New value for property `tunnelServiceUrl`
       */
      sTunnelServiceUrl?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Shares the data to Jam group
     */
    shareToJam(): void;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The OData service URL needed for the share component.
     */
    oDataServiceUrl?: URI | PropertyBindingInfo | `{${string}}`;

    collaborationHostODataServiceUrl?:
      | URI
      | PropertyBindingInfo
      | `{${string}}`;

    tunnelServiceUrl?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * A JSON object passed to the share component. This object contains the following properties:
     * 	 - id (optional): is the object Id to be shared in SAP Jam, i.e a URL that navigates back to the same
     *     object in the application
     * 	 - display (optional): is a UI5 control to be displayed in the component UI
     * 	 - share (optional): is a note that will be displayed in the component UI and shared to SAP Jam too
     */
    object?: object | PropertyBindingInfo | `{${string}}`;

    attachments?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * A Business Object such as an Opportunity, Sales Order, Account, etc. from the back-end that will be shared
     * as a Featured External Object in a Group in Jam.
     * 	 - {string} appContext: The application context. Example: "CRM", "SD", etc.
     * 	 - {string} odataServicePath: The relative path to the OData Service. Example: "/sap/opu/odata/sap/ODATA_SRV"
     *
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity", etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be a simple
     *     ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'", etc.
     *
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity 123",
     *     "Account 123", etc.   These attributes are not enforced by the UI (missing or incorrect values
     *     are not validated), but they are required to make the integration work. These attributes also should
     *     be mapped in the Back-end System and Jam in order to make the External Object work.
     * **Note:** the externalObject is dependent on object.id, therefore, the object.id must also be passed
     * to the Share Component. See the parameter "object" for more information.
     */
    externalObject?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/collaboration/components/fiori/sharing/dialog/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { ID } from "sap/ui/core/library";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The Share Dialog component is an SAPUI5 component that you can use to create a dialog in your application
   * to enable you to enter or edit information shared to SAP Jam.
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the share dialog component
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new component. See the documentation of the component's properties for the structure
       * of the expected data.
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the share dialog component
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new component, generated automatically if no id is given
       */
      sId?: ID,
      /**
       * initial settings for the new component. See the documentation of the component's properties for the structure
       * of the expected data.
       */
      mSettings?: $ComponentSettings
    );

    /**
     * Creates a new subclass of class sap.collaboration.components.fiori.sharing.dialog.Component with name
     * `sClassName` and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.fiori.sharing.dialog.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * Gets current value of property {@link #getAttachments attachments}.
     *
     * When you want to provide the user with the option to share file attachments, then the following properties
     * need to be specified:
     * 	 - attachmentsArray: An array of {@link sap.collaboration.components.fiori.sharing.attachment.Attachment }
     *     objects. This array offers users a list of files they can attach.
     *
     * @returns Value of property `attachments`
     */
    getAttachments(): object;
    /**
     * Gets current value of property {@link #getExternalObject externalObject}.
     *
     * A Business Object such as an Opportunity, Sales Order, Account, etc. from the back-end that will be shared
     * as a Featured External Object in a Group in Jam.
     * 	 - {string} appContext: The application context. Example: "CRM", "SD", etc.
     * 	 - {string} odataServicePath: The relative path to the OData Service. Example: "/sap/opu/odata/sap/ODATA_SRV"
     *
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity", etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be a simple
     *     ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'", etc.
     *
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity 123",
     *     "Account 123", etc.   These attributes are not enforced by the UI (missing or incorrect values
     *     are not validated), but they are required to make the integration work. These attributes also should
     *     be mapped in the Back-end System and Jam in order to make the External Object work.
     *  **Note:** the externalObject is dependent on object.id, therefore, the object.id must also be passed
     * to the Share Component. See the parameter "object" for more information.
     *
     * @returns Value of property `externalObject`
     */
    getExternalObject(): object;
    /**
     * Gets current value of property {@link #getObject object}.
     *
     * A JSON object passed to the share component. This object contains the following properties:
     * 	 - id (optional): is the object Id to be shared in SAP Jam, i.e a URL( or a callback function that returns
     *     a URL) that navigates back to the same object in the application
     * 	 - display (optional): is a UI5 control to be displayed in the component UI
     *  **Note:** The preferred object to pass in the display parameter is `sap.m.ObjectListItem`. Using other
     * type of objects (for example: `ap.ui.commons.TextView`) may result in problems in the rendering of the
     * content which needs to be corrected by the application owners.
     * 	 - share (optional): is a note that will be displayed in the component UI and shared to SAP Jam too
     *
     *
     * @returns Value of property `object`
     */
    getObject(): object;
    /**
     * Opens the share component dialog
     */
    open(): void;
    /**
     * Sets a new value for property {@link #getAttachments attachments}.
     *
     * When you want to provide the user with the option to share file attachments, then the following properties
     * need to be specified:
     * 	 - attachmentsArray: An array of {@link sap.collaboration.components.fiori.sharing.attachment.Attachment }
     *     objects. This array offers users a list of files they can attach.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAttachments(
      /**
       * New value for property `attachments`
       */
      oAttachments: object
    ): this;
    /**
     * Sets a new value for property {@link #getExternalObject externalObject}.
     *
     * A Business Object such as an Opportunity, Sales Order, Account, etc. from the back-end that will be shared
     * as a Featured External Object in a Group in Jam.
     * 	 - {string} appContext: The application context. Example: "CRM", "SD", etc.
     * 	 - {string} odataServicePath: The relative path to the OData Service. Example: "/sap/opu/odata/sap/ODATA_SRV"
     *
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity", etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be a simple
     *     ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'", etc.
     *
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity 123",
     *     "Account 123", etc.   These attributes are not enforced by the UI (missing or incorrect values
     *     are not validated), but they are required to make the integration work. These attributes also should
     *     be mapped in the Back-end System and Jam in order to make the External Object work.
     *  **Note:** the externalObject is dependent on object.id, therefore, the object.id must also be passed
     * to the Share Component. See the parameter "object" for more information.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExternalObject(
      /**
       * New value for property `externalObject`
       */
      oExternalObject: object
    ): this;
    /**
     * Sets a new value for property {@link #getObject object}.
     *
     * A JSON object passed to the share component. This object contains the following properties:
     * 	 - id (optional): is the object Id to be shared in SAP Jam, i.e a URL( or a callback function that returns
     *     a URL) that navigates back to the same object in the application
     * 	 - display (optional): is a UI5 control to be displayed in the component UI
     *  **Note:** The preferred object to pass in the display parameter is `sap.m.ObjectListItem`. Using other
     * type of objects (for example: `ap.ui.commons.TextView`) may result in problems in the rendering of the
     * content which needs to be corrected by the application owners.
     * 	 - share (optional): is a note that will be displayed in the component UI and shared to SAP Jam too
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObject(
      /**
       * New value for property `object`
       */
      oObject: object
    ): this;
    /**
     * Setter for the Component settings.
     */
    setSettings(
      /**
       * A JSON object used to set the component settings, this object should contains the same properties used
       * in the constructor.
       */
      oSettings: object
    ): void;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    /**
     * When you want to provide the user with the option to share file attachments, then the following properties
     * need to be specified:
     * 	 - attachmentsArray: An array of {@link sap.collaboration.components.fiori.sharing.attachment.Attachment }
     *     objects. This array offers users a list of files they can attach.
     */
    attachments?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * A JSON object passed to the share component. This object contains the following properties:
     * 	 - id (optional): is the object Id to be shared in SAP Jam, i.e a URL( or a callback function that returns
     *     a URL) that navigates back to the same object in the application
     * 	 - display (optional): is a UI5 control to be displayed in the component UI
     *  **Note:** The preferred object to pass in the display parameter is `sap.m.ObjectListItem`. Using other
     * type of objects (for example: `ap.ui.commons.TextView`) may result in problems in the rendering of the
     * content which needs to be corrected by the application owners.
     * 	 - share (optional): is a note that will be displayed in the component UI and shared to SAP Jam too
     */
    object?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * A Business Object such as an Opportunity, Sales Order, Account, etc. from the back-end that will be shared
     * as a Featured External Object in a Group in Jam.
     * 	 - {string} appContext: The application context. Example: "CRM", "SD", etc.
     * 	 - {string} odataServicePath: The relative path to the OData Service. Example: "/sap/opu/odata/sap/ODATA_SRV"
     *
     * 	 - {string} collection: The name of the OData Collection. Example: "Account", "Opportunity", etc.
     * 	 - {string} key: The key to identify a particular instance of the Business Object. It can be a simple
     *     ID or a compound key. Example: "123", "ObjectID='123'", "ObjectID='123',ObjectType='BUS000123'", etc.
     *
     * 	 - {string} name: The short name of the Business Object. Example: "Sales Order 123", "Opportunity 123",
     *     "Account 123", etc.   These attributes are not enforced by the UI (missing or incorrect values
     *     are not validated), but they are required to make the integration work. These attributes also should
     *     be mapped in the Back-end System and Jam in order to make the External Object work.
     *  **Note:** the externalObject is dependent on object.id, therefore, the object.id must also be passed
     * to the Share Component. See the parameter "object" for more information.
     */
    externalObject?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/collaboration/components/socialprofile/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import { CSSSize } from "sap/ui/core/library";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { PlacementType } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * @experimental - The API is not stable and the UI is not finalized. The implementation for this feature
   * is subject to change.
   *
   * Social Profile Component
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the Social Profile Component.
     *
     * !!! EXPERIMENTAL !!!
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the Social Profile Component.
     *
     * !!! EXPERIMENTAL !!!
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );

    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Cleans up the component instance before destruction. [borrowed from sap.ui.core.Component]
     */
    static exit(): void;
    /**
     * Creates a new subclass of class sap.collaboration.components.socialprofile.Component with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.socialprofile.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Initializes the Component instance after creation. [borrowed from sap.ui.core.UIComponent]
     */
    static init(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Function is called when the rendering of the Component Container is completed. [borrowed from sap.ui.core.UIComponent]
     */
    static onAfterRendering(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Function is called when the rendering of the Component Container is started. [borrowed from sap.ui.core.UIComponent]
     */
    static onBeforeRendering(): void;
    /**
     * Opens the social profile component
     */
    static open(): void;
    /**
     * Setter for the Component settings
     */
    static setSettings(
      /**
       * A JSON object used to set the component settings, this object should contains the same properties used
       * in the constructor
       */
      oSettings: object
    ): void;
    /**
     * Getter for property `height`. Gets the height of the Social Profile
     *
     * Default value is `380px`
     *
     * @returns the value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Getter for property `memberId`. Gets the SAP Jam member id of the user
     *
     * @returns the value of property `memberId`
     */
    getMemberId(): string;
    /**
     * Getter for property `memberInfo`. Gets the SAP Jam member information
     *
     * @returns member information `memberInfo`
     */
    getMemberInfo(): object;
    /**
     * Getter for property `openingControl`. Gets the opening control for the Social Profile
     *
     * @returns the value of property `openingControl`
     */
    getOpeningControl(): object;
    /**
     * Getter for property `placement`. Gets the placement of the Social Profile
     *
     * Default value is `sap.m.PlacementType.Auto`
     *
     * @returns the value of property `placement`
     */
    getPlacement(): PlacementType | keyof typeof PlacementType;
    /**
     * Getter for property `width`. Gets the width of the Social Profile
     *
     * Default value is `300px`
     *
     * @returns the value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Setter for property `height`. Sets the height of the Social Profile
     *
     * Default value is `380px`
     *
     * @returns `this` to allow method chaining
     */
    setHeight(
      /**
       * new value for property `height`
       */
      sHeight: string
    ): this;
    /**
     * Setter for property `memberId`. Sets the memberId of the user
     *
     * @returns `this` to allow method chaining
     */
    setMemberId(
      /**
       * new value for property `memberId`
       */
      sMemberId: string
    ): this;
    /**
     * Setter for property `memberInfo`. Sets the memberInformation of the user
     *
     * @returns `this` to allow method chaining
     */
    setMemberInfo(
      /**
       * new value for property `memberInfo`
       */
      oMemberInfo: object
    ): this;
    /**
     * Setter for property `openingControl`. Sets the opening control for the Social Profile
     *
     * @returns `this` to allow method chaining
     */
    setOpeningControl(
      /**
       * new value for property `openingControl`
       */
      oOpeningControl: object
    ): this;
    /**
     * Setter for property `placement`. Sets the placement of the Social Profile
     *
     * Default value is `sap.m.PlacementType.Auto`
     *
     * @returns `this` to allow method chaining
     */
    setPlacement(
      /**
       * new value for property `placement`
       */
      sPlacement: PlacementType | keyof typeof PlacementType
    ): this;
    /**
     * Setter for property `width`. Sets the width of the Social Profile
     *
     * Default value is `300px`
     *
     * @returns `this` to allow method chaining
     */
    setWidth(
      /**
       * new value for property `width`
       */
      sWidth: string
    ): this;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    placement?:
      | (PlacementType | keyof typeof PlacementType)
      | PropertyBindingInfo
      | `{${string}}`;

    memberId?: string | PropertyBindingInfo;

    memberInfo?: object | PropertyBindingInfo | `{${string}}`;

    openingControl?: object | PropertyBindingInfo | `{${string}}`;

    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    width?: CSSSize | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/collaboration/components/socialtimeline/Component" {
  import {
    default as UIComponent,
    $UIComponentSettings,
  } from "sap/ui/core/UIComponent";

  import Event from "sap/ui/base/Event";

  import {
    TimelineAlignment,
    TimelineAxisOrientation,
  } from "sap/suite/ui/commons/library";

  import ComponentMetadata from "sap/ui/core/ComponentMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * @deprecated (since 1.34.0) - For new integrations and existing implementations running on release 1.32
   * or later, use the Group Feed component (sap.collaboration.components.feed.Component), Business Object
   * mode(sap.collaboration.FeedType.BusinessObjectGroups). Note that the Group Feed component does not display
   * any updates related to the business object from the back-end system (system updates).
   *
   * Social Timeline
   */
  export default class Component extends UIComponent {
    /**
     * Constructor for the Social Timeline Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );
    /**
     * Constructor for the Social Timeline Component.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ComponentSettings
    );

    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * The method to create the Content (UI Control Tree) of the Component.
     */
    static createContent(): void;
    /**
     * Delete a Timeline Entry. This method should be called when a custom action requires a deletion of a Timeline
     * entry and should only be called if an a delete to the backend is performed successfully.
     */
    static deleteTimelineEntry(
      /**
       * the id of the timeline entry to delete
       */
      sId: string
    ): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Cleans up the component instance before destruction.
     */
    static exit(): void;
    /**
     * Creates a new subclass of class sap.collaboration.components.socialtimeline.Component with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.UIComponent.extend}.
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Component>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.collaboration.components.socialtimeline.Component.
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ComponentMetadata;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Initializes the Component instance after creation.
     */
    static init(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Function is called when the rendering of the Component Container is completed.
     */
    static onAfterRendering(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Function is called when the rendering of the Component Container is started.
     */
    static onBeforeRendering(): void;
    /**
     * Set the current business object for the social timeline to display. Note: The function setBusinessObjectMap
     * must be called once before calling setBusinessObject for the first time.
     */
    static setBusinessObject(
      /**
       * an object that contains the key and name for the business object
       */
      oObject: object
    ): void;
    /**
     * @deprecated (since 1.28.5) - This method is deprecated, use method setBusinessObject instead.
     *
     * Set the current business object for the social timeline to display. Note: The function setBusinessObjectMap
     * must be called once before calling setBusinessObjectKey for the first time.
     */
    static setBusinessObjectKey(sKey: string): void;
    /**
     * Set the business object map. It is used to initialize the data needed to retrieve the timeline entries.
     * This function must be called once before calling setBusinessObjectKey for the first time.
     */
    static setBusinessObjectMap(
      /**
       * required - JSON object containing the following properties:
       * 	{sap.ui.model.odata.ODataModel} serviceModel required - OData model to retrieve timeline entries {string }
       * servicePath: The relative path to the OData service for the business object (example: "/sap/opu/odata/sap/ODATA_SRV")
       * {string} collection: Entity collection name of the business object {string} applicationContext:
       * The application context (example: "CRM", "SD", etc.) {function} customActionCallback: A callback
       * function to determine which timeline entries should receive the custom action. The function should return
       * an array of text/value objects.
       */
      businessObjectMap: object
    ): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Set property of component
     */
    static setProperty(): void;
    /**
     * Setter for the Component settings.
     */
    static setSettings(
      /**
       * A JSON object used to set the component settings, this object should contains the same properties used
       * in the constructor.
       */
      settings: object
    ): void;
    /**
     * Update a Timeline Entry text. This method should be called when a custom action requires a content update
     * of a Timeline entry and should only be called if an an update to the backend is performed successfully.
     */
    static updateTimelineEntry(
      /**
       * the text that will be displayed in the content of the timeline entry
       */
      sText: string,
      /**
       * the id of the timeline entry to update
       */
      sId: string
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:customActionPress customActionPress} event of
     * this `sap.collaboration.components.socialtimeline.Component`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.collaboration.components.socialtimeline.Component` itself.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCustomActionPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.collaboration.components.socialtimeline.Component`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:customActionPress customActionPress} event of
     * this `sap.collaboration.components.socialtimeline.Component`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.collaboration.components.socialtimeline.Component` itself.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCustomActionPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.collaboration.components.socialtimeline.Component`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:customActionPress customActionPress} event
     * of this `sap.collaboration.components.socialtimeline.Component`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCustomActionPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * Fires event {@link #event:customActionPress customActionPress} to attached listeners.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCustomActionPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Getter for property `alignment`. Timeline item alignment.
     *
     * Default value is `Right`
     *
     * @returns the value of property `alignment`
     */
    getAlignment(): TimelineAlignment | keyof typeof TimelineAlignment;
    /**
     * Getter for property `axisOrientation`. Timeline axis orientation.
     *
     * Default value is `Vertical`
     *
     * @returns the value of property `axisOrientation`
     */
    getAxisOrientation():
      | TimelineAxisOrientation
      | keyof typeof TimelineAxisOrientation;
    /**
     * Getter for property `customFilter`.
     *
     * Default value is `[]`. The customFilter is an array of objects, each object contains text and value.
     * Text is the name of the filter category and value is the filter value.
     *
     * @returns the value of property `customFilter`
     */
    getCustomFilter(): any[];
    /**
     * Gets current value of property {@link #getEnableSocial enableSocial}.
     *
     * Default value is `true`.
     *
     * @returns Value of property `enableSocial`
     */
    getEnableSocial(): boolean;
    /**
     * Getter for property `noDataText`. This text is displayed when the control has no data.
     *
     * Default value is empty/`undefined`
     *
     * @returns the value of property `noDataText`
     */
    getNoDataText(): string;
    /**
     * Getter for property `showIcons`. Show icon on each Timeline item.
     *
     * Default value is `true`
     *
     * @returns the value of property `showIcons`
     */
    getShowIcons(): boolean;
    /**
     * Getter for property `visible`. Set Timeline control visibility
     *
     * Default value is `true`
     *
     * @returns the value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Getter for property `width`. Sets the width of the Timeline.
     *
     * Default value is `100%`
     *
     * @returns the value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Setter for property `alignment`.
     *
     * Default value is `Right`
     *
     * @returns `this` to allow method chaining
     */
    setAlignment(
      /**
       * new value for property `alignment`
       */
      oAlignment: TimelineAlignment | keyof typeof TimelineAlignment
    ): this;
    /**
     * Setter for property `axisOrientation`.
     *
     * Default value is `Vertical`
     *
     * @returns `this` to allow method chaining
     */
    setAxisOrientation(
      /**
       * new value for property `axisOrientation`
       */
      oAxisOrientation:
        | TimelineAxisOrientation
        | keyof typeof TimelineAxisOrientation
    ): this;
    /**
     * Sets a new value for property {@link #getCustomFilter customFilter}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomFilter(
      /**
       * New value for property `customFilter`
       */
      sCustomFilter: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSocial enableSocial}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSocial(
      /**
       * New value for property `enableSocial`
       */
      bEnableSocial?: boolean
    ): this;
    /**
     * Setter for property `noDataText`.
     *
     * Default value is empty/`undefined`
     *
     * @returns `this` to allow method chaining
     */
    setNoDataText(
      /**
       * new value for property `noDataText`
       */
      sNoDataText: string
    ): this;
    /**
     * Setter for property `showIcons`.
     *
     * Default value is `true`
     *
     * @returns `this` to allow method chaining
     */
    setShowIcons(
      /**
       * new value for property `showIcons`
       */
      bShowIcons: boolean
    ): this;
    /**
     * Setter for property `visible`.
     *
     * Default value is `true`
     *
     * @returns `this` to allow method chaining
     */
    setVisible(
      /**
       * new value for property `visible`
       */
      bVisible: boolean
    ): this;
    /**
     * Setter for property `width`.
     *
     * Default value is `100%`
     *
     * @returns `this` to allow method chaining
     */
    setWidth(
      /**
       * new value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }

  export interface $ComponentSettings extends $UIComponentSettings {
    enableSocial?: boolean | PropertyBindingInfo | `{${string}}`;

    alignment?:
      | (TimelineAlignment | keyof typeof TimelineAlignment)
      | PropertyBindingInfo
      | `{${string}}`;

    axisOrientation?:
      | (TimelineAxisOrientation | keyof typeof TimelineAxisOrientation)
      | PropertyBindingInfo
      | `{${string}}`;

    noDataText?: string | PropertyBindingInfo;

    showIcons?: boolean | PropertyBindingInfo | `{${string}}`;

    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    customFilter?: object[] | PropertyBindingInfo | `{${string}}`;

    customActionPress?: (oEvent: Event) => void;
  }

  export interface Component$CustomActionPressEventParameters {}

  export type Component$CustomActionPressEvent = Event<
    Component$CustomActionPressEventParameters,
    Component
  >;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/collaboration/components/feed/Component": undefined;

    "sap/collaboration/components/fiori/feed/Component": undefined;

    "sap/collaboration/components/fiori/feed/dialog/Component": undefined;

    "sap/collaboration/components/fiori/notification/Component": undefined;

    "sap/collaboration/components/fiori/sharing/attachment/Attachment": undefined;

    "sap/collaboration/components/fiori/sharing/Component": undefined;

    "sap/collaboration/components/fiori/sharing/dialog/Component": undefined;

    "sap/collaboration/components/socialprofile/Component": undefined;

    "sap/collaboration/components/socialtimeline/Component": undefined;

    "sap/collaboration/library": undefined;
  }
}
