import { isSaxParserToJSON, isSaxText } from "../../utils/xmlParser.js";
export default class HtmlReporter {
    #resourcePath;
    #context;
    constructor(resourcePath, context) {
        this.#resourcePath = resourcePath;
        this.#context = context;
    }
    addMessage(id, argsOrNode, node) {
        if (!argsOrNode) {
            throw new Error("Invalid arguments: Missing second argument");
        }
        let args;
        if (isSaxParserToJSON(argsOrNode)) {
            node = argsOrNode;
            args = null;
        }
        else if (isSaxText(argsOrNode)) {
            node = argsOrNode;
            args = null;
        }
        else if (!node) {
            throw new Error("Invalid arguments: Missing 'node'");
        }
        else {
            args = argsOrNode;
        }
        let startPos;
        if (isSaxParserToJSON(node)) {
            startPos = node.openStart;
        }
        else {
            startPos = node.start;
        }
        this.#context.addLintingMessage(this.#resourcePath, id, args, {
            line: startPos.line + 1,
            column: startPos.character + 1,
        });
    }
    addCoverageInfo({ node, message, category }) {
        let line = 0, column = 0, endLine = 0, endColumn = 0;
        if (isSaxParserToJSON(node)) {
            ({ line, character: column } = node.openStart);
            ({ line: endLine, character: endColumn } = node.closeEnd);
        }
        this.#context.addCoverageInfo(this.#resourcePath, {
            category,
            // One-based to be aligned with most IDEs
            line: line + 1,
            column: column + 1,
            endLine: endLine + 1,
            endColumn: endColumn + 1,
            message,
        });
    }
}
//# sourceMappingURL=HtmlReporter.js.map