declare module "sap/suite/ui/microchart/AreaMicroChartViewType" {
	import {AreaMicroChartViewType} from "sap/suite/ui/microchart/library";

	/**
	 * Enum of available views for the area micro chart concerning the position of the labels.
	 *
	 * @public
	 * @since 1.34
	*/
	export default AreaMicroChartViewType;
}

declare module "sap/suite/ui/microchart/BulletMicroChartModeType" {
	import {BulletMicroChartModeType} from "sap/suite/ui/microchart/library";

	/**
	 * Defines if the horizontal bar represents a current value only or if it represents the delta between a current value and a threshold value.
	 *
	 * @public
	 * @since 1.34
	*/
	export default BulletMicroChartModeType;
}

declare module "sap/suite/ui/microchart/CommonBackgroundType" {
	import {CommonBackgroundType} from "sap/suite/ui/microchart/library";

	/**
	 * Lists the available theme-specific background colors.
	 *
	 * @public
	 * @since 1.34
	*/
	export default CommonBackgroundType;
}

declare module "sap/suite/ui/microchart/ComparisonMicroChartViewType" {
	import {ComparisonMicroChartViewType} from "sap/suite/ui/microchart/library";

	/**
	 * Lists the views of the comparison micro chart concerning the position of titles and labels.
	 *
	 * @public
	 * @since 1.34
	*/
	export default ComparisonMicroChartViewType;
}

declare module "sap/suite/ui/microchart/DeltaMicroChartViewType" {
	import {DeltaMicroChartViewType} from "sap/suite/ui/microchart/library";

	/**
	 * Lists the views of the delta micro chart concerning the position of titles.
	 *
	 * @public
	 * @since 1.61
	*/
	export default DeltaMicroChartViewType;
}

declare module "sap/suite/ui/microchart/HorizontalAlignmentType" {
	import {HorizontalAlignmentType} from "sap/suite/ui/microchart/library";

	/**
	 * Alignment type for the microchart content.
	 *
	 * @public
	 * @since 1.62
	*/
	export default HorizontalAlignmentType;
}

declare module "sap/suite/ui/microchart/LineType" {
	import {LineType} from "sap/suite/ui/microchart/library";

	/**
	 * Type of the microchart line.
	 *
	 * @public
	 * @since 1.60
	*/
	export default LineType;
}
