declare module "sap/ui/integration/AttributesLayoutType" {
	import {AttributesLayoutType} from "sap/ui/integration/library";

	/**
	 * Defines the layout type of the List card attributes.
	 *
	 * @public
	 * @since 1.96
	*/
	export default AttributesLayoutType;
}

declare module "sap/ui/integration/CardActionType" {
	import {CardActionType} from "sap/ui/integration/library";

	/**
	 * Enumeration of possible card action types.
	 *
	 * @experimental (since 1.64) - Disclaimer: this property is in a beta state - incompatible API changes may be done before its official public release. Use at your own discretion.
	 * @public
	*/
	export default CardActionType;
}

declare module "sap/ui/integration/CardArea" {
	import {CardArea} from "sap/ui/integration/library";

	/**
	 * Defines the areas in a card.
	 *
	 * @public
	 * @since 1.86
	*/
	export default CardArea;
}

declare module "sap/ui/integration/CardBlockingMessageType" {
	import {CardBlockingMessageType} from "sap/ui/integration/library";

	/**
	 * Card blocking message types.
	 *
	 * @experimental (since 1.114)
	 * @public
	*/
	export default CardBlockingMessageType;
}

declare module "sap/ui/integration/CardDataMode" {
	import {CardDataMode} from "sap/ui/integration/library";

	/**
	 * Possible data modes for <code>{@link sap.ui.integration.widgets.Card}</code>.
	 *
	 * @experimental (since 1.65)
	 * @public
	 * @since 1.65
	*/
	export default CardDataMode;
}

declare module "sap/ui/integration/CardDesign" {
	import {CardDesign} from "sap/ui/integration/library";

	/**
	 * Possible designs for <code>{@link sap.ui.integration.widgets.Card}</code>.
	 *
	 * @experimental (since 1.109)
	 * @public
	 * @since 1.109
	*/
	export default CardDesign;
}

declare module "sap/ui/integration/CardDisplayVariant" {
	import {CardDisplayVariant} from "sap/ui/integration/library";

	/**
	 * Possible variants for <code>{@link sap.ui.integration.widgets.Card}</code> rendering and behavior.
	 *
	 * @experimental (since 1.118) - For usage only by Work Zone.
	 * @public
	 * @since 1.118
	*/
	export default CardDisplayVariant;
}

declare module "sap/ui/integration/CardPreviewMode" {
	import {CardPreviewMode} from "sap/ui/integration/library";

	/**
	 * Preview modes for <code>{@link sap.ui.integration.widgets.Card}</code>. Helpful in scenarios when the end user is choosing or configuring a card.
	 *
	 * @experimental (since 1.112)
	 * @public
	 * @since 1.112
	*/
	export default CardPreviewMode;
}
