/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Below are constants for LView indices to help us look up LView members
// without having to remember the specific indices.
// Uglify will inline these when minifying so there shouldn't be a cost.
export const HOST = 0;
export const TVIEW = 1;
// Shared with LContainer
export const FLAGS = 2;
export const PARENT = 3;
export const NEXT = 4;
export const T_HOST = 5;
// End shared with LContainer
export const HYDRATION = 6;
export const CLEANUP = 7;
export const CONTEXT = 8;
export const INJECTOR = 9;
export const ENVIRONMENT = 10;
export const RENDERER = 11;
export const CHILD_HEAD = 12;
export const CHILD_TAIL = 13;
// FIXME(misko): Investigate if the three declarations aren't all same thing.
export const DECLARATION_VIEW = 14;
export const DECLARATION_COMPONENT_VIEW = 15;
export const DECLARATION_LCONTAINER = 16;
export const PREORDER_HOOK_FLAGS = 17;
export const QUERIES = 18;
export const ID = 19;
export const EMBEDDED_VIEW_INJECTOR = 20;
export const ON_DESTROY_HOOKS = 21;
export const EFFECTS_TO_SCHEDULE = 22;
export const REACTIVE_TEMPLATE_CONSUMER = 23;
/**
 * Size of LView's header. Necessary to adjust for it when setting slots.
 *
 * IMPORTANT: `HEADER_OFFSET` should only be referred to the in the `ɵɵ*` instructions to translate
 * instruction index into `LView` index. All other indexes should be in the `LView` index space and
 * there should be no need to refer to `HEADER_OFFSET` anywhere else.
 */
export const HEADER_OFFSET = 25;
//# sourceMappingURL=data:application/json;base64,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