/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class AddTimeUnitArgument
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="org.apache.http.client.config.RequestConfig.Builder setConnectionRequestTimeout(int)")
    private final String methodPattern;
    @Option(displayName="Time unit", description="The TimeUnit enum value we want to add to the method invocation. Defaults to `MILLISECONDS`.", example="MILLISECONDS", required=false)
    private final @Nullable TimeUnit timeUnit;

    public String getDisplayName() {
        return "Adds a TimeUnit argument to the matched method invocations";
    }

    public String getDescription() {
        return "In Apache Http Client 5.x migration, an extra TimeUnit argument is required in the timeout and duration methods. Previously in 4.x, all these methods were implicitly having the timeout or duration expressed in milliseconds, but in 5.x the unit of the timeout or duration is required. So, by default this recipe adds `TimeUnit.MILLISECONDS`, it is possible to specify this as a parameter. Since all affected methods of the Apache Http Client 5.x migration only have one integer/long argument, the recipe applies with matched method invocations of exactly one parameter.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher matcher;
            {
                this.matcher = new MethodMatcher(AddTimeUnitArgument.this.methodPattern);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (this.matcher.matches((MethodCall)m)) {
                    JavaTemplate template = JavaTemplate.builder((String)(StringUtils.repeat((String)"#{any()}, ", (int)m.getArguments().size()) + "TimeUnit.#{}")).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpclient5", "httpcore5"})).imports(new String[]{"java.util.concurrent.TimeUnit"}).build();
                    ArrayList<TimeUnit> arguments = new ArrayList<TimeUnit>(m.getArguments());
                    arguments.add(AddTimeUnitArgument.this.timeUnit != null ? AddTimeUnitArgument.this.timeUnit : TimeUnit.MILLISECONDS);
                    m = (J.MethodInvocation)template.apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), arguments.toArray(new Object[0]));
                    this.maybeAddImport("java.util.concurrent.TimeUnit");
                }
                return m;
            }
        };
    }

    @Generated
    public AddTimeUnitArgument(String methodPattern, @Nullable TimeUnit timeUnit) {
        this.methodPattern = methodPattern;
        this.timeUnit = timeUnit;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public @Nullable TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public String toString() {
        return "AddTimeUnitArgument(methodPattern=" + this.getMethodPattern() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTimeUnitArgument)) {
            return false;
        }
        AddTimeUnitArgument other = (AddTimeUnitArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddTimeUnitArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }
}

