/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.SourceProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class AndroidProjectVariant {
    private static final Logger logger = Logging.getLogger(AndroidProjectVariant.class);
    private final String name;
    private final Map<String, Set<Path>> javaSourceSets;
    private final Map<String, Set<Path>> kotlinSourceSets;
    private final Map<String, Set<Path>> resourcesSourceSets;
    private final Set<String> sourceSetNames = new HashSet<String>();
    private final Set<Path> compileClasspath;
    private final Set<Path> runtimeClasspath;

    AndroidProjectVariant(String name, Map<String, Set<Path>> javaSourceSets, Map<String, Set<Path>> kotlinSourceSets, Map<String, Set<Path>> resourcesSourceSets, Set<Path> compileClasspath, Set<Path> runtimeClasspath) {
        this.name = name;
        this.javaSourceSets = javaSourceSets;
        this.kotlinSourceSets = kotlinSourceSets;
        this.resourcesSourceSets = resourcesSourceSets;
        this.compileClasspath = compileClasspath;
        this.runtimeClasspath = runtimeClasspath;
        this.sourceSetNames.addAll(javaSourceSets.keySet());
        this.sourceSetNames.addAll(kotlinSourceSets.keySet());
        this.sourceSetNames.addAll(this.resourcesSourceSets.keySet());
    }

    String getName() {
        return this.name;
    }

    Set<String> getSourceSetNames() {
        return this.sourceSetNames;
    }

    Set<Path> getJavaDirectories(String sourceSetName) {
        return this.javaSourceSets.computeIfAbsent(sourceSetName, key -> Collections.emptySet());
    }

    Set<Path> getKotlinDirectories(String sourceSetName) {
        return this.kotlinSourceSets.computeIfAbsent(sourceSetName, key -> Collections.emptySet());
    }

    Set<Path> getResourcesDirectories(String sourceSetName) {
        return this.resourcesSourceSets.computeIfAbsent(sourceSetName, key -> Collections.emptySet());
    }

    Set<Path> getCompileClasspath() {
        return this.compileClasspath;
    }

    Set<Path> getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    static AndroidProjectVariant fromBaseVariant(BaseVariant baseVariant) {
        HashMap<String, Set<Path>> javaSourceSets = new HashMap<String, Set<Path>>();
        HashMap<String, Set<Path>> kotlinSourceSets = new HashMap<String, Set<Path>>();
        HashMap<String, Set<Path>> resourceSourceSets = new HashMap<String, Set<Path>>();
        for (SourceProvider sourceProvider : baseVariant.getSourceSets()) {
            AndroidProjectVariant.addSourceSets(javaSourceSets, sourceProvider.getName(), sourceProvider.getJavaDirectories());
            if (AndroidProjectVariant.hasMethod(baseVariant, "getKotlinDirectories", new Class[0])) {
                AndroidProjectVariant.addSourceSets(kotlinSourceSets, sourceProvider.getName(), sourceProvider.getKotlinDirectories());
            }
            AndroidProjectVariant.addSourceSets(resourceSourceSets, sourceProvider.getName(), sourceProvider.getResDirectories());
            AndroidProjectVariant.addSourceSets(resourceSourceSets, sourceProvider.getName(), sourceProvider.getResourcesDirectories());
        }
        LinkedHashSet<Path> compileClasspath = new LinkedHashSet<Path>();
        try {
            baseVariant.getCompileClasspath(null).getFiles().stream().map(File::toPath).forEach(compileClasspath::add);
        }
        catch (RuntimeException e) {
            logger.warn("Unable to determine compile class path", (Throwable)e);
        }
        LinkedHashSet<Path> runtimeClasspath = new LinkedHashSet<Path>();
        try {
            baseVariant.getRuntimeConfiguration().getFiles().stream().map(File::toPath).forEach(runtimeClasspath::add);
        }
        catch (Exception e) {
            logger.warn("Unable to determine runtime class path", (Throwable)e);
        }
        return new AndroidProjectVariant(baseVariant.getName(), javaSourceSets, kotlinSourceSets, resourceSourceSets, compileClasspath, runtimeClasspath);
    }

    private static void addSourceSets(Map<String, Set<Path>> sourceSets, String name, Collection<File> directories) {
        sourceSets.put(name, directories.stream().map(File::toPath).collect(Collectors.toSet()));
    }

    private static boolean hasMethod(BaseVariant baseVariant, String methodName, Class<?> ... paramTypes) {
        try {
            baseVariant.getClass().getMethod(methodName, paramTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

