/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.options.Option;
import org.openrewrite.gradle.DelegatingProjectParser;
import org.openrewrite.gradle.GradleProjectParser;
import org.openrewrite.gradle.ResolveRewriteDependenciesTask;
import org.openrewrite.gradle.RewriteExtension;

public abstract class AbstractRewriteTask
extends DefaultTask {
    protected ResolveRewriteDependenciesTask resolveDependenciesTask;
    protected boolean dumpGcActivity;
    protected GradleProjectParser gpp;
    protected RewriteExtension extension;

    public <T extends AbstractRewriteTask> T setExtension(RewriteExtension extension) {
        this.extension = extension;
        return (T)((Object)this);
    }

    public <T extends AbstractRewriteTask> T setResolveDependenciesTask(ResolveRewriteDependenciesTask resolveDependenciesTask) {
        this.resolveDependenciesTask = resolveDependenciesTask;
        this.dependsOn(new Object[]{resolveDependenciesTask});
        return (T)((Object)this);
    }

    @Option(description="Dump GC activity related to parsing.", option="dumpGcActivity")
    public void setDumpGcActivity(boolean dumpGcActivity) {
        this.dumpGcActivity = dumpGcActivity;
    }

    @Input
    public boolean isDumpGcActivity() {
        return this.dumpGcActivity;
    }

    @Internal
    protected <T extends GradleProjectParser> T getProjectParser() {
        if (this.gpp == null) {
            if (this.extension == null) {
                throw new IllegalArgumentException("Must configure extension");
            }
            if (this.resolveDependenciesTask == null) {
                throw new IllegalArgumentException("Must configure resolveDependenciesTask");
            }
            Set<Path> classpath = this.resolveDependenciesTask.getResolvedDependencies().stream().map(File::toPath).collect(Collectors.toSet());
            this.gpp = new DelegatingProjectParser(this.getProject(), this.extension, classpath);
        }
        return (T)this.gpp;
    }

    @Input
    public List<String> getActiveRecipes() {
        return this.getProjectParser().getActiveRecipes();
    }

    @Input
    public List<String> getActiveStyles() {
        return this.getProjectParser().getActiveStyles();
    }

    protected void shutdownRewrite() {
        this.getProjectParser().shutdownRewrite();
    }
}

