/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.gradle.api.Project;
import org.openrewrite.gradle.RewriteExtension;

public class DefaultRewriteExtension
implements RewriteExtension {
    private static final String magicalMetricsLogString = "LOG";
    private final List<String> activeRecipes = new ArrayList<String>();
    private final List<String> activeStyles = new ArrayList<String>();
    private boolean configFileSetDeliberately;
    protected final Project project;
    private File configFile;
    private Provider<File> checkstyleConfigProvider;
    private Provider<Map<String, Object>> checkstylePropertiesProvider;
    private File checkstyleConfigFile;
    private String metricsUri = "LOG";
    private boolean enableExperimentalGradleBuildScriptParsing = true;
    private final List<String> exclusions = new ArrayList<String>();
    private final List<String> plainTextMasks = new ArrayList<String>();
    private int sizeThresholdMb = 10;
    @Nullable
    private String rewriteVersion;
    @Nullable
    private Properties versionProps;
    private boolean logCompilationWarningsAndErrors;
    private boolean failOnInvalidActiveRecipes;
    private boolean failOnDryRunResults;
    private boolean throwOnParseFailures;
    private String rewriteGradleModelVersion;
    private String rewriteKotlinVersion;
    private String rewritePythonVersion;

    public DefaultRewriteExtension(Project project) {
        this.project = project;
        this.configFile = project.file((Object)"rewrite.yml");
    }

    @Override
    public void setConfigFile(File configFile) {
        this.configFileSetDeliberately = true;
        this.configFile = configFile;
    }

    @Override
    public void setConfigFile(String configFilePath) {
        this.configFileSetDeliberately = true;
        this.configFile = this.project.file((Object)configFilePath);
    }

    @Override
    public void setCheckstyleConfigFile(File configFile) {
        this.checkstyleConfigFile = configFile;
    }

    @Override
    @Nullable
    public File getCheckstyleConfigFile() {
        if (this.checkstyleConfigFile == null && this.checkstyleConfigProvider != null) {
            try {
                return (File)this.checkstyleConfigProvider.get();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.checkstyleConfigFile;
    }

    @Override
    public Map<String, Object> getCheckstyleProperties() {
        if (this.checkstyleConfigProvider == null) {
            return Collections.emptyMap();
        }
        return (Map)this.checkstylePropertiesProvider.get();
    }

    @Override
    public boolean getConfigFileSetDeliberately() {
        return this.configFileSetDeliberately;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public void enableRouteMetricsToLog() {
        this.metricsUri = magicalMetricsLogString;
    }

    @Override
    public boolean isRouteMetricsToLog() {
        return this.metricsUri.equals(magicalMetricsLogString);
    }

    @Override
    public String getMetricsUri() {
        return this.metricsUri;
    }

    @Override
    public void setMetricsUri(String value) {
        this.metricsUri = value;
    }

    @Override
    public void activeRecipe(String ... recipes) {
        this.activeRecipes.addAll(Arrays.asList(recipes));
    }

    @Override
    public void clearActiveRecipes() {
        this.activeRecipes.clear();
    }

    @Override
    public void setActiveRecipes(List<String> activeRecipes) {
        this.activeRecipes.clear();
        this.activeRecipes.addAll(activeRecipes);
    }

    @Override
    public void activeStyle(String ... styles) {
        this.activeStyles.addAll(Arrays.asList(styles));
    }

    @Override
    public void clearActiveStyles() {
        this.activeStyles.clear();
    }

    @Override
    public void setActiveStyles(List<String> activeStyles) {
        this.activeRecipes.clear();
        this.activeRecipes.addAll(activeStyles);
    }

    @Override
    public List<String> getActiveStyles() {
        return this.activeStyles;
    }

    @Override
    public List<String> getActiveRecipes() {
        return this.activeRecipes;
    }

    private Properties getVersionProps() {
        if (this.versionProps == null) {
            try (InputStream is = DefaultRewriteExtension.class.getResourceAsStream("/rewrite/versions.properties");){
                this.versionProps = new Properties();
                this.versionProps.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.versionProps;
    }

    @Override
    public String getRewriteVersion() {
        if (this.rewriteVersion == null) {
            return this.getVersionProps().getProperty("org.openrewrite:rewrite-core");
        }
        return this.rewriteVersion;
    }

    @Override
    public String getRewriteAllVersion() {
        if (this.rewriteVersion == null) {
            return this.getVersionProps().getProperty("org.openrewrite.recipe:rewrite-all");
        }
        return this.rewriteVersion;
    }

    @Override
    public String getRewriteGradleModelVersion() {
        if (this.rewriteGradleModelVersion == null) {
            this.rewriteGradleModelVersion = this.getVersionProps().getProperty("org.openrewrite.gradle.tooling:model");
        }
        return this.rewriteGradleModelVersion;
    }

    @Override
    public String getRewriteKotlinVersion() {
        if (this.rewriteKotlinVersion == null) {
            this.rewriteKotlinVersion = this.getVersionProps().getProperty("org.openrewrite:rewrite-kotlin");
        }
        return this.rewriteKotlinVersion;
    }

    @Override
    public String getRewritePythonVersion() {
        if (this.rewritePythonVersion == null) {
            this.rewritePythonVersion = this.getVersionProps().getProperty("org.openrewrite:rewrite-python");
        }
        return this.rewritePythonVersion;
    }

    @Override
    public String getCheckstyleToolsVersion() {
        return this.getVersionProps().getProperty("com.puppycrawl.tools:checkstyle");
    }

    @Override
    public void setRewriteVersion(String value) {
        this.rewriteVersion = value;
    }

    @Override
    public boolean getFailOnInvalidActiveRecipes() {
        return this.failOnInvalidActiveRecipes;
    }

    @Override
    public void setFailOnInvalidActiveRecipes(boolean failOnInvalidActiveRecipes) {
        this.failOnInvalidActiveRecipes = failOnInvalidActiveRecipes;
    }

    @Override
    public boolean getFailOnDryRunResults() {
        return this.failOnDryRunResults;
    }

    @Override
    public void setFailOnDryRunResults(boolean failOnDryRunResults) {
        this.failOnDryRunResults = failOnDryRunResults;
    }

    @Override
    public boolean getLogCompilationWarningsAndErrors() {
        return this.logCompilationWarningsAndErrors;
    }

    @Override
    public void setLogCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
    }

    @Override
    public Provider<File> getCheckstyleConfigProvider() {
        return this.checkstyleConfigProvider;
    }

    @Override
    public void setCheckstyleConfigProvider(Provider<File> checkstyleConfigProvider) {
        this.checkstyleConfigProvider = checkstyleConfigProvider;
    }

    @Override
    public Provider<Map<String, Object>> getCheckstylePropertiesProvider() {
        return this.checkstylePropertiesProvider;
    }

    @Override
    public void setCheckstylePropertiesProvider(Provider<Map<String, Object>> checkstylePropertiesProvider) {
        this.checkstylePropertiesProvider = checkstylePropertiesProvider;
    }

    @Override
    public boolean isEnableExperimentalGradleBuildScriptParsing() {
        return this.enableExperimentalGradleBuildScriptParsing;
    }

    @Override
    public void setEnableExperimentalGradleBuildScriptParsing(boolean enableExperimentalGradleBuildScriptParsing) {
        this.enableExperimentalGradleBuildScriptParsing = enableExperimentalGradleBuildScriptParsing;
    }

    @Override
    public List<String> getExclusions() {
        return this.exclusions;
    }

    @Override
    public void exclusion(String ... exclusions) {
        this.exclusions.addAll(Arrays.asList(exclusions));
    }

    @Override
    public void exclusion(Collection<String> exclusions) {
        this.exclusions.addAll(exclusions);
    }

    @Override
    public List<String> getPlainTextMasks() {
        if (this.plainTextMasks.isEmpty()) {
            this.plainTextMasks.addAll(Arrays.asList("**gradlew", "**META-INF/services/**", "**/META-INF/spring.factories", "**/META-INF/spring/**", "**.gitignore", "**.gitattributes", "**.java-version", "**.sdkmanrc", "**.sh", "**.bash", "**.bat", "**.ksh", "**.txt", "**.jsp", "**.sql", "**Dockerfile", "**Jenkinsfile", "**.kts"));
        }
        return this.plainTextMasks;
    }

    @Override
    public void plainTextMask(String ... masks) {
        this.plainTextMasks.addAll(Arrays.asList(masks));
    }

    @Override
    public void plainTextMask(Collection<String> masks) {
        this.plainTextMasks.addAll(masks);
    }

    @Override
    public int getSizeThresholdMb() {
        return this.sizeThresholdMb;
    }

    @Override
    public void setSizeThresholdMb(int thresholdMb) {
        this.sizeThresholdMb = thresholdMb;
    }

    @Override
    public String getJacksonModuleKotlinVersion() {
        return this.getVersionProps().getProperty("com.fasterxml.jackson.module:jackson-module-kotlin");
    }

    @Override
    public boolean getThrowOnParseFailures() {
        if (this.project.getProperties().containsKey("rewrite.throwOnParseFailures")) {
            return true;
        }
        return this.throwOnParseFailures;
    }

    @Override
    public void setThrowOnParseFailures(boolean throwOnParseFailures) {
        this.throwOnParseFailures = throwOnParseFailures;
    }
}

