/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import groovy.lang.Closure;
import java.util.ArrayList;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.RewriteDiscoverTask;
import org.openrewrite.gradle.RewriteDryRunTask;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.RewriteRunTask;

public class RewritePlugin
implements Plugin<Project> {
    public void apply(Project rootProject) {
        if (!rootProject.getPath().equals(":")) {
            return;
        }
        RewriteExtension maybeExtension = (RewriteExtension)((Object)rootProject.getExtensions().findByType(RewriteExtension.class));
        if (maybeExtension == null) {
            maybeExtension = (RewriteExtension)((Object)rootProject.getExtensions().create("rewrite", RewriteExtension.class, new Object[]{rootProject}));
            maybeExtension.setToolVersion("2.x");
        }
        RewriteExtension extension = maybeExtension;
        Configuration rewriteConf = (Configuration)rootProject.getConfigurations().maybeCreate("rewrite");
        ArrayList<Project> projects = new ArrayList<Project>();
        AbstractRewriteTask rewriteRun = ((RewriteRunTask)rootProject.getTasks().create("rewriteRun", RewriteRunTask.class)).setConfiguration(rewriteConf).setExtension(extension).setProjects(projects);
        AbstractRewriteTask rewriteDryRun = ((RewriteDryRunTask)rootProject.getTasks().create("rewriteDryRun", RewriteDryRunTask.class)).setConfiguration(rewriteConf).setExtension(extension).setProjects(projects);
        AbstractRewriteTask rewriteDiscover = ((RewriteDiscoverTask)rootProject.getTasks().create("rewriteDiscover", RewriteDiscoverTask.class)).setConfiguration(rewriteConf).setExtension(extension).setProjects(projects);
        rootProject.allprojects(project -> {
            projects.add((Project)project);
            project.getPlugins().all(plugin -> {
                if (plugin instanceof CheckstylePlugin) {
                    CheckstyleExtension checkstyleExtension = (CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class);
                    extension.checkstyleConfigProvider = () -> ((CheckstyleExtension)checkstyleExtension).getConfigFile();
                    extension.checkstylePropertiesProvider = () -> ((CheckstyleExtension)checkstyleExtension).getConfigProperties();
                }
                if (!(plugin instanceof JavaBasePlugin)) {
                    return;
                }
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                javaConvention.getSourceSets().all(sourceSet -> {
                    Task compileTask = project.getTasks().getByPath(sourceSet.getCompileJavaTaskName());
                    rewriteRun.dependsOn(new Object[]{compileTask});
                    rewriteDryRun.dependsOn(new Object[]{compileTask});
                });
            });
        });
    }

    private Closure<Task> taskClosure(final Action<Task> configFun) {
        return new Closure<Task>((Object)this){

            public void doCall(Task arg) {
                configFun.execute((Object)arg);
            }
        };
    }
}

