/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.RewriteReflectiveFacade;

public class RewriteDryRunTask
extends AbstractRewriteTask {
    private static final Logger log = Logging.getLogger(RewriteDryRunTask.class);

    @Internal
    Path getReportPath() {
        return this.getProject().getBuildDir().toPath().resolve("reports").resolve("rewrite").resolve("rewrite.patch");
    }

    @Inject
    public RewriteDryRunTask() {
        this.setGroup("rewrite");
        this.setDescription("Dry run the active refactoring recipes. No source files will be changed.");
        this.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @TaskAction
    public void run() {
        AbstractRewriteTask.ResultsContainer results = this.listResults();
        if (results.isNotEmpty()) {
            for (RewriteReflectiveFacade.Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn("These recipes would generate new file {}:", (Object)result.getAfter().getSourcePath());
                this.logRecipesThatMadeChanges(result);
            }
            for (RewriteReflectiveFacade.Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn("These recipes would delete file {}:", (Object)result.getBefore().getSourcePath());
                this.logRecipesThatMadeChanges(result);
            }
            for (RewriteReflectiveFacade.Result result : results.moved) {
                assert (result.getBefore() != null);
                assert (result.getAfter() != null);
                this.getLog().warn("These recipes would move file from {} to {}:", (Object)result.getBefore().getSourcePath(), (Object)result.getAfter().getSourcePath());
                this.logRecipesThatMadeChanges(result);
            }
            for (RewriteReflectiveFacade.Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn("These recipes would make results to {}:", (Object)result.getBefore().getSourcePath());
                this.logRecipesThatMadeChanges(result);
            }
            Path patchFile = this.getReportPath();
            patchFile.getParent().toFile().mkdirs();
            try (BufferedWriter writer = Files.newBufferedWriter(patchFile, new OpenOption[0]);){
                Stream.concat(Stream.concat(results.generated.stream(), results.deleted.stream()), Stream.concat(results.moved.stream(), results.refactoredInPlace.stream())).map(RewriteReflectiveFacade.Result::diff).forEach(diff -> {
                    try {
                        writer.write(diff + "\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to generate rewrite result file.", e);
            }
            this.getLog().warn("Report available:");
            this.getLog().warn(RewriteDryRunTask.indent(1, patchFile.normalize().toString()));
            this.getLog().warn("Run 'gradle rewriteRun' to apply the recipes.");
            if (this.getExtension().getFailOnDryRunResults()) {
                throw new RuntimeException("Applying recipes would make changes. See logs for more details.");
            }
        } else {
            this.getLog().lifecycle("Applying recipes would make no changes. No report generated.");
        }
    }
}

