/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.service.ServiceRegistry;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.binary.Binary;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.gradle.GradleProjectParser;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.SanitizedMarkerPrinter;
import org.openrewrite.gradle.TimeUtils;
import org.openrewrite.gradle.isolated.ResourceParser;
import org.openrewrite.gradle.isolated.ResultsContainer;
import org.openrewrite.gradle.isolated.ui.RecipeDescriptorTreePrompter;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleProjectBuilder;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParsingExecutionContextView;

public class DefaultProjectParser
implements GradleProjectParser {
    private static final JavaTypeCache javaTypeCache = new JavaTypeCache();
    private static final String LOG_INDENT_INCREMENT = "    ";
    private final Logger logger = Logging.getLogger(DefaultProjectParser.class);
    protected final Path baseDir;
    protected final RewriteExtension extension;
    protected final Project project;
    private final List<Marker> sharedProvenance;
    private List<NamedStyles> styles;
    private Environment environment;

    public DefaultProjectParser(Project project, RewriteExtension extension) {
        this.baseDir = DefaultProjectParser.repositoryRoot(project);
        this.extension = extension;
        this.project = project;
        BuildEnvironment buildEnvironment = BuildEnvironment.build(System::getenv);
        this.sharedProvenance = Stream.of(buildEnvironment, this.gitProvenance(this.baseDir, buildEnvironment), OperatingSystemProvenance.current(), new BuildTool(Tree.randomId(), BuildTool.Type.Gradle, project.getGradle().getGradleVersion())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static Path repositoryRoot(Project project) {
        Path buildRoot;
        Path maybeBaseDir;
        for (maybeBaseDir = buildRoot = project.getRootProject().getProjectDir().toPath(); maybeBaseDir != null && !Files.exists(maybeBaseDir.resolve(".git"), new LinkOption[0]); maybeBaseDir = maybeBaseDir.getParent()) {
        }
        if (maybeBaseDir == null) {
            return buildRoot;
        }
        return maybeBaseDir;
    }

    @Nullable
    private GitProvenance gitProvenance(Path baseDir, @Nullable BuildEnvironment buildEnvironment) {
        try {
            return GitProvenance.fromProjectDirectory((Path)baseDir, (BuildEnvironment)buildEnvironment);
        }
        catch (Exception e) {
            this.logger.debug("Unable to determine git provenance", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private String getPropertyWithVariantNames(String property) {
        String maybeProp = System.getProperty("rewrite." + property + "s");
        if (maybeProp == null) {
            maybeProp = System.getProperty("rewrite." + property);
        }
        if (maybeProp == null) {
            maybeProp = System.getProperty(property + "s");
        }
        if (maybeProp == null) {
            maybeProp = System.getProperty(property);
        }
        return maybeProp;
    }

    @Override
    public List<String> getActiveRecipes() {
        String activeRecipe = this.getPropertyWithVariantNames("activeRecipe");
        if (activeRecipe == null) {
            return new ArrayList<String>(this.extension.getActiveRecipes());
        }
        return Arrays.asList(activeRecipe.split(","));
    }

    @Override
    public List<String> getActiveStyles() {
        String activeStyle = this.getPropertyWithVariantNames("activeStyle");
        if (activeStyle == null) {
            return new ArrayList<String>(this.extension.getActiveStyles());
        }
        return Arrays.asList(activeStyle.split(","));
    }

    @Override
    public List<String> getAvailableStyles() {
        return this.environment().listStyles().stream().map(NamedStyles::getName).collect(Collectors.toList());
    }

    @Override
    public void discoverRecipes(boolean interactive, ServiceRegistry serviceRegistry) {
        Collection<RecipeDescriptor> availableRecipeDescriptors = this.listRecipeDescriptors();
        if (interactive) {
            this.logger.quiet("Entering interactive mode, Ctrl-C to exit...");
            UserInputHandler prompter = (UserInputHandler)serviceRegistry.get(UserInputHandler.class);
            RecipeDescriptorTreePrompter treePrompter = new RecipeDescriptorTreePrompter(prompter);
            RecipeDescriptor rd = treePrompter.execute(availableRecipeDescriptors);
            this.writeRecipeDescriptor(rd);
        } else {
            List<String> activeRecipes = this.getActiveRecipes();
            List<String> availableStyles = this.getAvailableStyles();
            List<String> activeStyles = this.getActiveStyles();
            this.logger.quiet("Available Recipes:");
            for (RecipeDescriptor recipe : availableRecipeDescriptors) {
                this.logger.quiet(DefaultProjectParser.indent(1, recipe.getName()));
            }
            this.logger.quiet(DefaultProjectParser.indent(0, ""));
            this.logger.quiet("Available Styles:");
            for (String style : availableStyles) {
                this.logger.quiet(DefaultProjectParser.indent(1, style));
            }
            this.logger.quiet(DefaultProjectParser.indent(0, ""));
            this.logger.quiet("Active Styles:");
            for (String style : activeStyles) {
                this.logger.quiet(DefaultProjectParser.indent(1, style));
            }
            this.logger.quiet(DefaultProjectParser.indent(0, ""));
            this.logger.quiet("Active Recipes:");
            for (String activeRecipe : activeRecipes) {
                this.logger.quiet(DefaultProjectParser.indent(1, activeRecipe));
            }
            this.logger.quiet(DefaultProjectParser.indent(0, ""));
            this.logger.quiet("Found " + availableRecipeDescriptors.size() + " available recipes and " + availableStyles.size() + " available styles.");
            this.logger.quiet("Configured with " + activeRecipes.size() + " active recipes and " + activeStyles.size() + " active styles.");
        }
    }

    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.environment().listRecipeDescriptors();
    }

    private void writeRecipeDescriptor(RecipeDescriptor rd) {
        this.logger.quiet(DefaultProjectParser.indent(0, rd.getDisplayName()));
        this.logger.quiet(DefaultProjectParser.indent(1, rd.getName()));
        if (rd.getDescription() != null && !rd.getDescription().isEmpty()) {
            this.logger.quiet(DefaultProjectParser.indent(1, rd.getDescription()));
        }
        if (!rd.getOptions().isEmpty()) {
            this.logger.quiet(DefaultProjectParser.indent(0, "options: "));
            for (OptionDescriptor od : rd.getOptions()) {
                this.logger.quiet(DefaultProjectParser.indent(1, od.getName() + ": " + od.getType() + (od.isRequired() ? "!" : "")));
                if (od.getDescription() == null || od.getDescription().isEmpty()) continue;
                this.logger.quiet(DefaultProjectParser.indent(2, od.getDescription()));
            }
        }
        this.logger.quiet("");
    }

    private static String indent(int indent, CharSequence content) {
        StringBuilder prefix = DefaultProjectParser.repeat(indent);
        return prefix.append(content).toString();
    }

    private static StringBuilder repeat(int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * LOG_INDENT_INCREMENT.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(LOG_INDENT_INCREMENT);
        }
        return buffer;
    }

    @Override
    public Collection<Path> listSources() {
        TreeSet<Path> result;
        ResourceParser rp = new ResourceParser(this.baseDir, this.project, this.extension, new JavaTypeCache());
        try {
            result = new TreeSet<Path>(rp.listSources(this.project.getProjectDir().toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        JavaPluginConvention javaConvention = (JavaPluginConvention)this.project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention != null) {
            for (SourceSet sourceSet : javaConvention.getSourceSets()) {
                sourceSet.getAllJava().getFiles().stream().filter(it -> it.isFile() && (it.getName().endsWith(".java") || it.getName().endsWith(".kt"))).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).forEach(result::add);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dryRun(Path reportPath, boolean dumpGcActivity, Consumer<Throwable> onError) {
        ParsingExecutionContextView ctx = ParsingExecutionContextView.view((ExecutionContext)new InMemoryExecutionContext(onError));
        if (dumpGcActivity) {
            SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
            try (JvmHeapPressureMetrics heapMetrics = new JvmHeapPressureMetrics();){
                heapMetrics.bindTo((MeterRegistry)meterRegistry);
                new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
                File rewriteBuildDir = new File(this.project.getBuildDir(), "/rewrite");
                if (!rewriteBuildDir.exists() && !rewriteBuildDir.mkdirs()) return;
                File rewriteGcLog = new File(rewriteBuildDir, "rewrite-gc.csv");
                try (FileOutputStream fos = new FileOutputStream(rewriteGcLog, false);
                     BufferedWriter logWriter = new BufferedWriter(new PrintWriter(fos));){
                    logWriter.write("file,jvm.gc.overhead,g1.old.gen.size\n");
                    ctx.setParsingListener((input, sourceFile) -> {
                        try {
                            logWriter.write(input.getPath() + ",");
                            logWriter.write(meterRegistry.get("jvm.gc.overhead").gauge().value() + ",");
                            Gauge g1Used = meterRegistry.find("jvm.memory.used").tag("id", "G1 Old Gen").gauge();
                            logWriter.write((g1Used == null ? "" : Double.toString(g1Used.value())) + "\n");
                        }
                        catch (IOException e) {
                            this.logger.error("Unable to write rewrite GC log");
                            throw new UncheckedIOException(e);
                        }
                    });
                    this.dryRun(reportPath, this.listResults((ExecutionContext)ctx));
                    logWriter.flush();
                    this.logger.lifecycle("Wrote rewrite GC log: {}", new Object[]{rewriteGcLog.getAbsolutePath()});
                    return;
                }
                catch (IOException e) {
                    this.logger.error("Unable to write rewrite GC log", (Throwable)e);
                    throw new UncheckedIOException(e);
                }
            }
        } else {
            this.dryRun(reportPath, this.listResults((ExecutionContext)ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dryRun(Path reportPath, ResultsContainer results) {
        block25: {
            try {
                Throwable firstException = results.getFirstException();
                if (firstException != null) {
                    this.logger.error("The recipe produced an error. Please report this to the recipe author.");
                    if (firstException instanceof RuntimeException) {
                        throw (RuntimeException)firstException;
                    }
                    throw new RuntimeException(firstException);
                }
                if (results.isNotEmpty()) {
                    for (Result result : results.generated) {
                        assert (result.getAfter() != null);
                        this.logger.warn("These recipes would generate new file {}:", (Object)result.getAfter().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    for (Result result : results.deleted) {
                        assert (result.getBefore() != null);
                        this.logger.warn("These recipes would delete file {}:", (Object)result.getBefore().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    for (Result result : results.moved) {
                        assert (result.getBefore() != null);
                        assert (result.getAfter() != null);
                        this.logger.warn("These recipes would move file from {} to {}:", (Object)result.getBefore().getSourcePath(), (Object)result.getAfter().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    for (Result result : results.refactoredInPlace) {
                        assert (result.getBefore() != null);
                        this.logger.warn("These recipes would make results to {}:", (Object)result.getBefore().getSourcePath());
                        this.logRecipesThatMadeChanges(result);
                    }
                    reportPath.getParent().toFile().mkdirs();
                    try (BufferedWriter writer = Files.newBufferedWriter(reportPath, new OpenOption[0]);){
                        Stream.concat(Stream.concat(results.generated.stream(), results.deleted.stream()), Stream.concat(results.moved.stream(), results.refactoredInPlace.stream())).filter(it -> !(it.getAfter() instanceof Binary) && !(it.getAfter() instanceof Quark)).map(Result::diff).forEach(diff -> {
                            try {
                                writer.write(diff + "\n");
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to generate rewrite result file.", e);
                    }
                    this.logger.warn("Report available:");
                    this.logger.warn("    {}", (Object)reportPath.normalize());
                    this.logger.warn("Run 'gradle rewriteRun' to apply the recipes.");
                    if (((RewriteExtension)this.project.getExtensions().getByType(RewriteExtension.class)).getFailOnDryRunResults()) {
                        throw new RuntimeException("Applying recipes would make changes. See logs for more details.");
                    }
                    break block25;
                }
                this.logger.lifecycle("Applying recipes would make no changes. No report generated.");
            }
            finally {
                this.shutdownRewrite();
            }
        }
    }

    @Override
    public void run(Consumer<Throwable> onError) {
        this.run(this.listResults((ExecutionContext)new InMemoryExecutionContext(onError)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ResultsContainer results) {
        block30: {
            try {
                if (!results.isNotEmpty()) break block30;
                Throwable firstException = results.getFirstException();
                if (firstException != null) {
                    this.logger.error("The recipe produced an error. Please report this to the recipe author.");
                    if (firstException instanceof RuntimeException) {
                        throw (RuntimeException)firstException;
                    }
                    throw new RuntimeException(firstException);
                }
                for (Result result : results.generated) {
                    assert (result.getAfter() != null);
                    this.logger.lifecycle("Generated new file " + result.getAfter().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                for (Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    this.logger.lifecycle("Deleted file " + result.getBefore().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                for (Result result : results.moved) {
                    assert (result.getAfter() != null);
                    assert (result.getBefore() != null);
                    this.logger.lifecycle("File has been moved from " + result.getBefore().getSourcePath() + " to " + result.getAfter().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                for (Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    this.logger.lifecycle("Changes have been made to " + result.getBefore().getSourcePath() + " by:");
                    this.logRecipesThatMadeChanges(result);
                }
                this.logger.lifecycle("Please review and commit the results.");
                try {
                    Path originalLocation;
                    for (Result result : results.generated) {
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result);
                    }
                    for (Result result : results.deleted) {
                        assert (result.getBefore() != null);
                        originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                        boolean deleteSucceeded = originalLocation.toFile().delete();
                        if (deleteSucceeded) continue;
                        throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                    }
                    for (Result result : results.moved) {
                        assert (result.getBefore() != null);
                        originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                        File originalParentDir = originalLocation.toFile().getParentFile();
                        assert (result.getAfter() != null);
                        Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                        File afterParentDir = afterLocation.toFile().getParentFile();
                        if (afterParentDir.exists() && afterParentDir.getAbsolutePath().equalsIgnoreCase(originalParentDir.getAbsolutePath()) && !afterParentDir.getAbsolutePath().equals(originalParentDir.getAbsolutePath())) {
                            if (!originalParentDir.renameTo(afterParentDir)) {
                                throw new RuntimeException("Unable to rename directory from " + originalParentDir.getAbsolutePath() + " To: " + afterParentDir.getAbsolutePath());
                            }
                        } else if (!afterParentDir.exists() && !afterParentDir.mkdirs()) {
                            throw new RuntimeException("Unable to create directory " + afterParentDir.getAbsolutePath());
                        }
                        if (result.getAfter() instanceof Quark) {
                            Files.move(originalLocation, results.getProjectRoot().resolve(result.getAfter().getSourcePath()), new CopyOption[0]);
                            continue;
                        }
                        originalLocation.toFile().delete();
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result);
                    }
                    for (Result result : results.refactoredInPlace) {
                        DefaultProjectParser.writeAfter(results.getProjectRoot(), result);
                    }
                    List<Path> emptyDirectories = results.newlyEmptyDirectories();
                    if (!emptyDirectories.isEmpty()) {
                        this.logger.quiet("Removing {} newly empty directories:", new Object[]{emptyDirectories.size()});
                        for (Path emptyDirectory : emptyDirectories) {
                            this.logger.quiet("  {}", new Object[]{emptyDirectory});
                            Files.delete(emptyDirectory);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            finally {
                this.shutdownRewrite();
            }
        }
    }

    private static void writeAfter(Path root, Result result) {
        File targetFile;
        block32: {
            assert (result.getAfter() != null);
            Path targetPath = root.resolve(result.getAfter().getSourcePath());
            targetFile = targetPath.toFile();
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (result.getAfter() instanceof Binary) {
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    sourceFileWriter.write(((Binary)result.getAfter()).getBytes());
                    break block32;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (result.getAfter() instanceof Remote) {
                Remote remote = (Remote)result.getAfter();
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    int length;
                    InputStream source = remote.getInputStream((HttpSender)new HttpUrlConnectionSender());
                    byte[] buf = new byte[4096];
                    while ((length = source.read(buf)) > 0) {
                        sourceFileWriter.write(buf, 0, length);
                    }
                    break block32;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (!(result.getAfter() instanceof Quark)) {
                Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
                try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(targetPath, charset, new OpenOption[0]);){
                    sourceFileWriter.write(result.getAfter().printAll(new PrintOutputCapture((Object)0, (PrintOutputCapture.MarkerPrinter)new SanitizedMarkerPrinter())));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
        }
        if (result.getAfter().getFileAttributes() != null) {
            FileAttributes fileAttributes = result.getAfter().getFileAttributes();
            if (targetFile.canRead() != fileAttributes.isReadable()) {
                targetFile.setReadable(fileAttributes.isReadable());
            }
            if (targetFile.canWrite() != fileAttributes.isWritable()) {
                targetFile.setWritable(fileAttributes.isWritable());
            }
            if (targetFile.canExecute() != fileAttributes.isExecutable()) {
                targetFile.setExecutable(fileAttributes.isExecutable());
            }
        }
    }

    protected Environment environment() {
        if (this.environment == null) {
            Environment.Builder env;
            block10: {
                Map<Object, Object> gradleProps = this.project.getProperties().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Properties properties = new Properties();
                properties.putAll(gradleProps);
                env = Environment.builder();
                env.scanClassLoader(this.getClass().getClassLoader());
                File rewriteConfig = this.extension.getConfigFile();
                if (rewriteConfig.exists()) {
                    try (FileInputStream is = new FileInputStream(rewriteConfig);){
                        YamlResourceLoader resourceLoader = new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), properties, this.getClass().getClassLoader());
                        env.load((ResourceLoader)resourceLoader);
                        break block10;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to load rewrite configuration", e);
                    }
                }
                if (this.extension.getConfigFileSetDeliberately()) {
                    this.logger.warn("Rewrite configuration file {} does not exist.", (Object)rewriteConfig);
                }
            }
            this.environment = env.build();
        }
        return this.environment;
    }

    public List<SourceFile> parse(ExecutionContext ctx) {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        if (this.project == this.project.getRootProject()) {
            for (Project subProject : this.project.getSubprojects()) {
                sourceFiles.addAll(this.parse(subProject, alreadyParsed, ctx));
            }
        }
        sourceFiles.addAll(this.parse(this.project, alreadyParsed, ctx));
        return sourceFiles;
    }

    public List<SourceFile> parse(Project subproject, Set<Path> alreadyParsed, ExecutionContext ctx) {
        Collection exclusions = this.extension.getExclusions().stream().map(pattern -> subproject.getProjectDir().toPath().getFileSystem().getPathMatcher("glob:" + pattern)).collect(Collectors.toList());
        if (this.isExcluded(exclusions, subproject.getProjectDir().toPath())) {
            this.logger.lifecycle("Skipping project {} because it is excluded", new Object[]{subproject.getName()});
            return Collections.emptyList();
        }
        try {
            List parseFailures;
            Path buildScriptPath;
            SourceSetContainer sourceSets;
            List<Marker> projectProvenance;
            this.logger.lifecycle("Parsing sources from project {}", new Object[]{subproject.getName()});
            List<NamedStyles> styles = this.getStyles();
            JavaPluginConvention javaConvention = (JavaPluginConvention)subproject.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaConvention == null) {
                projectProvenance = this.sharedProvenance;
                sourceSets = Collections.emptySet();
            } else {
                projectProvenance = new ArrayList<Marker>(this.sharedProvenance);
                projectProvenance.add((Marker)new JavaVersion(Tree.randomId(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), javaConvention.getSourceCompatibility().toString(), javaConvention.getTargetCompatibility().toString()));
                projectProvenance.add((Marker)new JavaProject(Tree.randomId(), subproject.getName(), new JavaProject.Publication(subproject.getGroup().toString(), subproject.getName(), subproject.getVersion().toString())));
                sourceSets = javaConvention.getSourceSets();
            }
            if (subproject.getPlugins().hasPlugin("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension") || subproject.getExtensions().findByName("kotlin") != null && subproject.getExtensions().findByName("kotlin").getClass().getCanonicalName().startsWith("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension")) {
                return this.parseMultiplatformKotlinProject(subproject, exclusions, alreadyParsed, projectProvenance, ctx);
            }
            ResourceParser rp = new ResourceParser(this.baseDir, subproject, this.extension, javaTypeCache);
            List<Object> sourceFiles = new ArrayList<SourceFile>();
            for (SourceSet sourceSet : sourceSets) {
                List groovyPaths;
                List kotlinPaths;
                Set implementationClasspath;
                List javaPaths = sourceSet.getAllJava().getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".java")).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toList());
                Configuration implementation = subproject.getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
                Configuration rewriteImplementation = (Configuration)subproject.getConfigurations().maybeCreate("rewrite" + sourceSet.getImplementationConfigurationName());
                rewriteImplementation.extendsFrom(new Configuration[]{implementation});
                try {
                    implementationClasspath = rewriteImplementation.resolve();
                }
                catch (Exception e) {
                    this.logger.warn("Failed to resolve dependencies from {}:{}. Some type information may be incomplete", (Object)subproject.getPath(), (Object)sourceSet.getImplementationConfigurationName());
                    implementationClasspath = Collections.emptySet();
                }
                List dependencyPaths = Stream.concat(implementationClasspath.stream(), sourceSet.getCompileClasspath().getFiles().stream()).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).distinct().collect(Collectors.toList());
                if (javaPaths.size() > 0) {
                    this.logger.info("Parsing {} Java sources from {}/{}", new Object[]{javaPaths.size(), subproject.getName(), sourceSet.getName()});
                    Iterator jp = JavaParser.fromJavaVersion().classpath(dependencyPaths).styles(styles).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build();
                    Instant start = Instant.now();
                    List cus = jp.parse(javaPaths, this.baseDir, ctx);
                    alreadyParsed.addAll(javaPaths);
                    cus = ListUtils.map((List)cus, cu -> {
                        if (this.isExcluded(exclusions, cu.getSourcePath()) || cu.getSourcePath().startsWith(this.baseDir.relativize(subproject.getBuildDir().toPath()))) {
                            return null;
                        }
                        return cu;
                    });
                    Duration parseDuration = Duration.between(start, Instant.now());
                    this.logger.info("Finished parsing Java sources from {}/{} in {} ({} per source)", new Object[]{subproject.getName(), sourceSet.getName(), TimeUtils.prettyPrint(parseDuration), TimeUtils.prettyPrint(parseDuration.dividedBy(javaPaths.size()))});
                    sourceFiles.addAll(this.autodetectStyle(cus));
                }
                for (File resourcesDir : sourceSet.getResources().getSourceDirectories()) {
                    if (!resourcesDir.exists()) continue;
                    sourceFiles.addAll(rp.parse(resourcesDir.toPath(), alreadyParsed, ctx));
                }
                if (subproject.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm") && (kotlinPaths = sourceSet.getAllSource().getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".kt")).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toList())).size() > 0) {
                    this.logger.info("Parsing {} Kotlin sources from {}/{}", new Object[]{kotlinPaths.size(), subproject.getName(), sourceSet.getName()});
                    KotlinParser kp = KotlinParser.builder().classpath(dependencyPaths).styles(styles).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build();
                    Instant start = Instant.now();
                    List cus = kp.parse(kotlinPaths, this.baseDir, ctx);
                    alreadyParsed.addAll(kotlinPaths);
                    cus = ListUtils.map((List)cus, cu -> {
                        if (this.isExcluded(exclusions, cu.getSourcePath())) {
                            return null;
                        }
                        return cu;
                    });
                    Duration duration = Duration.between(start, Instant.now());
                    this.logger.info("Finished parsing Kotlin sources from {}/{} in {} ({} per source)", new Object[]{subproject.getName(), sourceSet.getName(), TimeUtils.prettyPrint(duration), TimeUtils.prettyPrint(duration.dividedBy(kotlinPaths.size()))});
                    sourceFiles.addAll(this.autodetectStyle(cus));
                }
                if (subproject.getPlugins().hasPlugin(GroovyPlugin.class) && (groovyPaths = sourceSet.getAllSource().getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".groovy")).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toList())).size() > 0) {
                    List dependenciesWithBuildDirs = Stream.concat(dependencyPaths.stream(), sourceSet.getOutput().getClassesDirs().getFiles().stream().map(File::toPath)).collect(Collectors.toList());
                    this.logger.info("Parsing {} Groovy sources from {}/{}", new Object[]{groovyPaths.size(), subproject.getName(), sourceSet.getName()});
                    GroovyParser gp = GroovyParser.builder().classpath(dependenciesWithBuildDirs).styles(styles).typeCache(javaTypeCache).logCompilationWarningsAndErrors(false).build();
                    Instant start = Instant.now();
                    List list = gp.parse(groovyPaths, this.baseDir, ctx);
                    alreadyParsed.addAll(groovyPaths);
                    List list2 = ListUtils.map((List)list, cu -> {
                        if (this.isExcluded(exclusions, cu.getSourcePath())) {
                            return null;
                        }
                        return cu;
                    });
                    Duration parseDuration = Duration.between(start, Instant.now());
                    this.logger.info("Finished parsing Groovy sources from {}/{} in {} ({} per source)", new Object[]{subproject.getName(), sourceSet.getName(), TimeUtils.prettyPrint(parseDuration), TimeUtils.prettyPrint(parseDuration.dividedBy(groovyPaths.size()))});
                    sourceFiles.addAll(this.autodetectStyle(list2));
                }
                JavaSourceSet sourceSetProvenance = JavaSourceSet.build((String)sourceSet.getName(), dependencyPaths, (JavaTypeCache)javaTypeCache, (boolean)false);
                List classpath = sourceSetProvenance.getClasspath();
                HashSet typesInUse = new HashSet();
                for (SourceFile sourceFile2 : sourceFiles) {
                    if (!(sourceFile2 instanceof JavaSourceFile)) continue;
                    typesInUse.addAll(((JavaSourceFile)sourceFile2).getTypesInUse().getTypesInUse());
                }
                for (JavaType javaType : typesInUse) {
                    if (!(javaType instanceof JavaType.FullyQualified)) continue;
                    classpath.add((JavaType.FullyQualified)javaType);
                }
                sourceSetProvenance = sourceSetProvenance.withClasspath(classpath);
                sourceFiles = ListUtils.map(sourceFiles, this.addProvenance(projectProvenance, (Marker)sourceSetProvenance));
            }
            sourceFiles.addAll(ListUtils.map(rp.parse(subproject.getProjectDir().toPath(), alreadyParsed, ctx), this.addProvenance(projectProvenance, null)));
            if (this.project.getBuildscript().getSourceFile() != null && !this.isExcluded(exclusions, buildScriptPath = this.baseDir.relativize(this.project.getBuildscript().getSourceFile().toPath()))) {
                sourceFiles = ListUtils.map(sourceFiles, sourceFile -> {
                    if (!sourceFile.getSourcePath().equals(buildScriptPath)) {
                        return sourceFile;
                    }
                    GradleProject gp = GradleProjectBuilder.gradleProject((Project)subproject);
                    return (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gp));
                });
            }
            if ((parseFailures = ParsingExecutionContextView.view((ExecutionContext)ctx).pollParseFailures()).size() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("There were problems parsing ").append(parseFailures.size()).append(" sources, run with --info to see full stack traces:\n");
                for (PlainText parseFailure : parseFailures) {
                    sb.append("  ").append(parseFailure.getSourcePath()).append("\n");
                }
                sb.append("Execution will continue but these files are unlikely to be affected by refactoring recipes.");
                if (this.extension.getThrowOnParseFailures()) {
                    throw new RuntimeException(sb.toString());
                }
                this.logger.warn("{}", (Object)sb);
                sourceFiles.addAll(parseFailures);
            }
            return sourceFiles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<SourceFile> parseMultiplatformKotlinProject(Project subproject, Collection<PathMatcher> exclusions, Set<Path> alreadyParsed, List<Marker> projectProvenance, ExecutionContext ctx) {
        SortedSet sourceSetNames;
        NamedDomainObjectContainer sourceSets;
        Object kotlinExtension = subproject.getExtensions().getByName("kotlin");
        try {
            Class<?> clazz = kotlinExtension.getClass().getClassLoader().loadClass("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension");
            sourceSets = (NamedDomainObjectContainer)clazz.getMethod("getSourceSets", new Class[0]).invoke(kotlinExtension, new Object[0]);
        }
        catch (Exception e) {
            this.logger.warn("Failed to resolve KotlinMultiplatformExtension from {}. No sources files from KotlinMultiplatformExtension will be parsed.", (Object)subproject.getPath());
            return Collections.emptyList();
        }
        try {
            sourceSetNames = (SortedSet)sourceSets.getClass().getMethod("getNames", new Class[0]).invoke((Object)sourceSets, new Object[0]);
        }
        catch (Exception e) {
            this.logger.warn("Failed to resolve SourceSetNames in KotlinMultiplatformExtension from {}. No sources files from KotlinMultiplatformExtension will be parsed.", (Object)subproject.getPath());
            return Collections.emptyList();
        }
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        for (String sourceSetName : sourceSetNames) {
            try {
                Set implementationClasspath;
                Object sourceSet = sourceSets.getClass().getMethod("getByName", String.class).invoke((Object)sourceSets, sourceSetName);
                SourceDirectorySet kotlinDirectorySet = (SourceDirectorySet)sourceSet.getClass().getMethod("getKotlin", new Class[0]).invoke(sourceSet, new Object[0]);
                List kotlinPaths = kotlinDirectorySet.getFiles().stream().filter(it -> it.isFile() && it.getName().endsWith(".kt")).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toList());
                String implementationName = (String)sourceSet.getClass().getMethod("getImplementationConfigurationName", new Class[0]).invoke(sourceSet, new Object[0]);
                Configuration implementation = subproject.getConfigurations().getByName(implementationName);
                Configuration rewriteImplementation = (Configuration)subproject.getConfigurations().maybeCreate("rewrite" + implementationName);
                rewriteImplementation.extendsFrom(new Configuration[]{implementation});
                try {
                    implementationClasspath = rewriteImplementation.resolve();
                }
                catch (Exception e) {
                    this.logger.warn("Failed to resolve dependencies from {}:{}. Some type information may be incomplete", (Object)subproject.getPath(), (Object)implementationName);
                    implementationClasspath = Collections.emptySet();
                }
                String compileName = (String)sourceSet.getClass().getMethod("getCompileOnlyConfigurationName", new Class[0]).invoke(sourceSet, new Object[0]);
                Configuration compileOnly = subproject.getConfigurations().getByName(compileName);
                Configuration rewriteCompileOnly = (Configuration)subproject.getConfigurations().maybeCreate("rewrite" + compileName);
                rewriteCompileOnly.setCanBeResolved(true);
                rewriteCompileOnly.extendsFrom(new Configuration[]{compileOnly});
                List dependencyPaths = Stream.concat(implementationClasspath.stream(), rewriteCompileOnly.getFiles().stream()).map(File::toPath).map(Path::toAbsolutePath).map(Path::normalize).distinct().collect(Collectors.toList());
                if (!kotlinPaths.isEmpty()) {
                    this.logger.info("Parsing {} Kotlin sources from {}/{}", new Object[]{kotlinPaths.size(), subproject.getName(), kotlinDirectorySet.getName()});
                    KotlinParser kp = KotlinParser.builder().classpath(dependencyPaths).styles(this.getStyles()).typeCache(javaTypeCache).logCompilationWarningsAndErrors(this.extension.getLogCompilationWarningsAndErrors()).build();
                    Instant start = Instant.now();
                    List cus = kp.parse(kotlinPaths, this.baseDir, ctx);
                    alreadyParsed.addAll(kotlinPaths);
                    cus = ListUtils.map((List)cus, cu -> {
                        if (this.isExcluded(exclusions, cu.getSourcePath())) {
                            return null;
                        }
                        return cu;
                    });
                    Duration parseDuration = Duration.between(start, Instant.now());
                    this.logger.info("Finished parsing Kotlin sources from {}/{} in {} ({} per source)", new Object[]{subproject.getName(), kotlinDirectorySet.getName(), TimeUtils.prettyPrint(parseDuration), TimeUtils.prettyPrint(parseDuration.dividedBy(kotlinPaths.size()))});
                    JavaSourceSet sourceSetProvenance = JavaSourceSet.build((String)sourceSetName, dependencyPaths, (JavaTypeCache)javaTypeCache, (boolean)false);
                    List classpath = sourceSetProvenance.getClasspath();
                    for (K.CompilationUnit cu2 : cus) {
                        for (JavaType type : cu2.getTypesInUse().getTypesInUse()) {
                            if (!(type instanceof JavaType.FullyQualified)) continue;
                            classpath.add((JavaType.FullyQualified)type);
                        }
                    }
                    sourceSetProvenance = sourceSetProvenance.withClasspath(classpath);
                    sourceFiles.addAll(ListUtils.map(this.autodetectStyle(cus), this.addProvenance(projectProvenance, (Marker)sourceSetProvenance)));
                }
                return sourceFiles;
            }
            catch (Exception e) {
                this.logger.warn("Failed to resolve sourceSet from {}:{}. Some type information may be incomplete", (Object)subproject.getPath(), (Object)sourceSetName);
            }
        }
        return Collections.emptyList();
    }

    private boolean isExcluded(Collection<PathMatcher> exclusions, Path path) {
        for (PathMatcher excluded : exclusions) {
            if (!excluded.matches(path)) continue;
            return true;
        }
        return false;
    }

    private List<NamedStyles> getStyles() {
        if (this.styles == null) {
            this.styles = this.environment().activateStyles(this.getActiveStyles());
            File checkstyleConfig = this.extension.getCheckstyleConfigFile();
            if (checkstyleConfig != null && checkstyleConfig.exists()) {
                try {
                    this.styles.add((NamedStyles)CheckstyleConfigLoader.loadCheckstyleConfig((Path)checkstyleConfig.toPath(), this.extension.getCheckstyleProperties()));
                }
                catch (Exception e) {
                    this.logger.warn("Unable to parse checkstyle configuration", (Throwable)e);
                }
            }
        }
        return this.styles;
    }

    protected ResultsContainer listResults(ExecutionContext ctx) {
        Environment env = this.environment();
        Recipe recipe = env.activateRecipes(this.getActiveRecipes());
        if (recipe.getRecipeList().isEmpty()) {
            this.logger.warn("No recipes were activated. Activate a recipe with rewrite.activeRecipe(\"com.fully.qualified.RecipeClassName\") in your build file, or on the command line with -DactiveRecipe=com.fully.qualified.RecipeClassName");
            return new ResultsContainer(this.baseDir, null);
        }
        this.logger.lifecycle("Validating active recipes");
        Collection validated = recipe.validateAll();
        List<Validated.Invalid> failedValidations = validated.stream().map(Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
        if (!failedValidations.isEmpty()) {
            failedValidations.forEach(failedValidation -> this.logger.error("Recipe validation error in {}: {}", new Object[]{failedValidation.getProperty(), failedValidation.getMessage(), failedValidation.getException()}));
            if (this.extension.getFailOnInvalidActiveRecipes()) {
                throw new RuntimeException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
            }
            this.logger.error("Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
        }
        List<SourceFile> sourceFiles = this.parse(ctx);
        this.logger.lifecycle("All sources parsed, running active recipes: {}", new Object[]{String.join((CharSequence)", ", this.getActiveRecipes())});
        RecipeRun recipeRun = recipe.run(sourceFiles, ctx);
        return new ResultsContainer(this.baseDir, recipeRun);
    }

    @Override
    public void shutdownRewrite() {
        J.clearCaches();
        GradleProjectBuilder.clearCaches();
    }

    private <T extends JavaSourceFile> List<T> autodetectStyle(List<T> sourceFiles) {
        Autodetect autodetect = Autodetect.detect(sourceFiles);
        return ListUtils.map(sourceFiles, cu -> (JavaSourceFile)cu.withMarkers(cu.getMarkers().add((Marker)autodetect)));
    }

    private <T extends SourceFile> UnaryOperator<T> addProvenance(List<Marker> projectProvenance, @Nullable Marker sourceSet) {
        return s -> {
            Markers m = s.getMarkers();
            for (Marker marker : projectProvenance) {
                m = m.add(marker);
            }
            if (sourceSet != null) {
                m = m.add(sourceSet);
            }
            return (SourceFile)s.withMarkers(m);
        };
    }

    protected void logRecipesThatMadeChanges(Result result) {
        String indent = LOG_INDENT_INCREMENT;
        String prefix = LOG_INDENT_INCREMENT;
        for (RecipeDescriptor recipeDescriptor : result.getRecipeDescriptorsThatMadeChanges()) {
            this.logRecipe(recipeDescriptor, prefix);
            prefix = prefix + indent;
        }
    }

    private void logRecipe(RecipeDescriptor rd, String prefix) {
        String opts;
        StringBuilder recipeString = new StringBuilder(prefix + rd.getName());
        if (!rd.getOptions().isEmpty() && !(opts = rd.getOptions().stream().map(option -> {
            if (option.getValue() != null) {
                return option.getName() + "=" + option.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "))).isEmpty()) {
            recipeString.append(": {").append(opts).append("}");
        }
        this.logger.warn("{}", (Object)recipeString);
        for (RecipeDescriptor rChild : rd.getRecipeList()) {
            this.logRecipe(rChild, prefix + LOG_INDENT_INCREMENT);
        }
    }
}

