/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.gradle.AbstractRewriteTask;

public class RewriteDryRunTask
extends AbstractRewriteTask {
    private static final Logger logger = Logging.getLogger(RewriteDryRunTask.class);

    @Internal
    public Path getReportPath() {
        return this.getProject().getBuildDir().toPath().resolve("reports").resolve("rewrite").resolve("rewrite.patch");
    }

    @Inject
    public RewriteDryRunTask() {
        this.setGroup("rewrite");
        this.setDescription("Run the active refactoring recipes, producing a patch file. No source files will be changed.");
        this.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
    }

    @TaskAction
    public void run() {
        this.getProjectParser().dryRun(this.getReportPath(), this.dumpGcActivity, this.useAstCache, throwable -> logger.warn("Error during rewrite dry run", throwable));
    }
}

