/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.constantfold;

import fj.data.Option;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.Literal;
import org.openrewrite.analysis.trait.expr.VarAccess;
import org.openrewrite.analysis.trait.variable.Variable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

@Incubating(since="2.4.0")
public class ConstantFold {
    public static Option<J> findConstantJ(Cursor cursor) {
        return ConstantFold.findConstantExpr(cursor).bind(expr -> {
            TopFinderVisitor topFinder = new TopFinderVisitor((Top)expr);
            AtomicReference found = new AtomicReference();
            topFinder.visit((Tree)cursor.dropParentUntil(J.CompilationUnit.class::isInstance).getValue(), found);
            return Option.some((Object)((J)found.get()));
        });
    }

    public static Option<Expr> findConstantExpr(Cursor cursor) {
        return DataFlowNode.of(cursor).bind(ConstantFold::findConstantExpr);
    }

    public static Option<Expr> findConstantExpr(DataFlowNode node) {
        return node.asExpr(VarAccess.class).map(VarAccess::getVariable).map(Variable::getAssignedValues).filter(values -> values.size() == 1).map(values -> (Expr)values.iterator().next()).orElse(() -> node.asExpr(Expr.class));
    }

    public static Option<Literal> findConstantLiteral(Cursor cursor) {
        return DataFlowNode.of(cursor).bind(ConstantFold::findConstantLiteral);
    }

    public static Option<Literal> findConstantLiteral(DataFlowNode node) {
        return ConstantFold.findConstantExpr(node).filter(Literal.class::isInstance).map(Literal.class::cast);
    }

    public static <T> Option<T> findConstantLiteralValue(Cursor cursor, Class<T> type) {
        ConstantFold.validateTypeIsPrimitiveType(type);
        return DataFlowNode.of(cursor).bind(n -> ConstantFold.findConstantLiteralValue(n, type));
    }

    public static <T> Option<T> findConstantLiteralValue(DataFlowNode node, Class<T> type) {
        ConstantFold.validateTypeIsPrimitiveType(type);
        return ConstantFold.findConstantLiteral(node).bind(Literal::getValue).filter(type::isInstance).map(type::cast);
    }

    private static void validateTypeIsPrimitiveType(Class<?> type) {
        if (!type.isPrimitive() && type != String.class) {
            throw new IllegalArgumentException("Type must be a primitive or String type");
        }
    }

    private static final class TopFinderVisitor
    extends JavaVisitor<AtomicReference<J>> {
        private final Top top;

        public J preVisit(J tree, AtomicReference<J> p) {
            if (this.top.getId().equals(tree.getId())) {
                this.stopAfterPreVisit();
                if (p.get() != null) {
                    throw new IllegalStateException("Multiple top-level trees found for " + this.top);
                }
                p.set(tree);
            }
            return (J)super.preVisit((Tree)tree, p);
        }

        public TopFinderVisitor(Top top) {
            this.top = top;
        }
    }
}

