/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.util;

import fj.data.Option;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;

public class CursorUtil {
    public static Option<Cursor> findCallableBlockCursor(Cursor start) {
        Iterator cursorPath = start.getPathAsCursors();
        Cursor methodDeclarationBlockCursor = null;
        while (cursorPath.hasNext()) {
            Cursor nextCursor = (Cursor)cursorPath.next();
            Object next = nextCursor.getValue();
            if (next instanceof J.Block) {
                methodDeclarationBlockCursor = nextCursor;
                if (!J.Block.isStaticOrInitBlock((Cursor)nextCursor) && !(nextCursor.getParentTreeCursor().getValue() instanceof J.Lambda)) continue;
                return Option.some((Object)nextCursor);
            }
            if (!(next instanceof J.MethodDeclaration)) continue;
            if (methodDeclarationBlockCursor == null && ((J.MethodDeclaration)next).getBody() != null) {
                methodDeclarationBlockCursor = new Cursor(nextCursor, (Object)((J.MethodDeclaration)next).getBody());
            }
            return Option.some((Object)methodDeclarationBlockCursor);
        }
        return Option.none();
    }

    @Incubating(since="2.4.0")
    public static Option<Cursor> findCursorForTree(Cursor start, Tree tree) {
        AtomicReference found = new AtomicReference();
        new TreeCursorFinderVisitor(tree).visitNonNull((Tree)start.getParentTreeCursor().getValue(), found, start);
        return Option.fromNull((Object)((Cursor)found.get()));
    }

    @Generated
    private CursorUtil() {
    }

    private static class TreeCursorFinderVisitor
    extends TreeVisitor<Tree, AtomicReference<Cursor>> {
        private final Tree tree;

        public Tree preVisit(Tree tree, AtomicReference<Cursor> cursorAtomicReference) {
            if (this.tree.isScope(tree)) {
                cursorAtomicReference.set(this.getCursor());
                this.stopAfterPreVisit();
            }
            return super.preVisit(tree, cursorAtomicReference);
        }

        @Generated
        public TreeCursorFinderVisitor(Tree tree) {
            this.tree = tree;
        }
    }
}

