/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.variable;

import fj.data.Validation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.VarAccess;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.analysis.trait.variable.Variable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class VariableUtil {
    public static Collection<Expr> findAssignedValues(Cursor scope, final Variable variable) {
        ArrayList<Expr> values = new ArrayList<Expr>();
        new JavaVisitor<List<Expr>>(){

            public J visitVariable(J.VariableDeclarations.NamedVariable var, List<Expr> exprs) {
                if (var.getInitializer() == null) {
                    return super.visitVariable(var, exprs);
                }
                Validation<TraitErrors, Variable> varDecl = Variable.viewOf(this.getCursor());
                Validation<TraitErrors, Expr> expr = Expr.viewOf(new Cursor(this.getCursor(), (Object)var.getInitializer()));
                if (((Boolean)varDecl.map(v -> v.equals(variable)).orSuccess((Object)false)).booleanValue()) {
                    exprs.add((Expr)expr.success());
                }
                return super.visitVariable(var, exprs);
            }

            public J visitAssignment(J.Assignment assignment, List<Expr> exprs) {
                final Validation[] varAccess = new Validation[]{VarAccess.viewOf(new Cursor(this.getCursor(), (Object)Objects.requireNonNull(Expression.unwrap((Expression)assignment.getVariable()))))};
                Validation<TraitErrors, Expr> expr = Expr.viewOf(new Cursor(this.getCursor(), (Object)assignment.getAssignment()));
                if (!varAccess[0].isSuccess()) {
                    new JavaIsoVisitor<Integer>(){

                        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Integer x) {
                            varAccess[0] = VarAccess.viewOf(new Cursor(this.getCursor(), (Object)fieldAccess.getName()));
                            return super.visitFieldAccess(fieldAccess, (Object)x);
                        }
                    }.visit((Tree)assignment.getVariable(), (Object)0, this.getCursor());
                }
                if (((Boolean)varAccess[0].map(v -> v.getVariable().equals(variable)).orSuccess((Object)false)).booleanValue()) {
                    exprs.add((Expr)expr.success());
                }
                return super.visitAssignment(assignment, exprs);
            }
        }.visit((Tree)scope.getValue(), values, scope.getParentOrThrow());
        return values;
    }
}

