/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.expr;

import fj.data.Option;
import fj.data.Validation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.analysis.trait.TraitFactory;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.VarAccessBase;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.analysis.trait.variable.Variable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public interface VarAccess
extends Expr {
    public String getName();

    public Variable getVariable();

    public boolean hasQualifier();

    public Option<Expr> getQualifier();

    public boolean isLocal();

    public boolean isLValue();

    public boolean isRValue();

    public static Validation<TraitErrors, VarAccess> viewOf(Cursor cursor) {
        return Factory.F.viewOf(cursor);
    }

    public static Collection<VarAccess> findAllInScope(Cursor scope, final Variable variable) {
        ArrayList<VarAccess> varAccesses = new ArrayList<VarAccess>();
        new JavaVisitor<List<VarAccess>>(){

            public J visitIdentifier(J.Identifier ident, List<VarAccess> varAccesses) {
                Validation<TraitErrors, VarAccess> varAccess = VarAccess.viewOf(this.getCursor());
                if (((Boolean)varAccess.map(v -> v.getVariable().equals(variable)).orSuccess((Object)false)).booleanValue()) {
                    varAccesses.add((VarAccess)varAccess.success());
                }
                return ident;
            }
        }.visit((Tree)scope.getValue(), varAccesses, scope.getParentOrThrow());
        return varAccesses;
    }

    public static enum Factory implements TraitFactory<VarAccess>
    {
        F;


        @Override
        public Validation<TraitErrors, VarAccess> viewOf(Cursor cursor) {
            if (cursor.getValue() instanceof J.Identifier) {
                J.Identifier ident = (J.Identifier)cursor.getValue();
                return VarAccessBase.viewOf(cursor, ident);
            }
            return TraitErrors.invalidTraitCreationType(VarAccess.class, cursor, J.Identifier.class);
        }
    }
}

