/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.util;

import java.util.Collection;
import java.util.stream.Collectors;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;

public final class FlagUtil {
    public static Flag fromModifierType(J.Modifier.Type modifierType) {
        switch (modifierType) {
            case Default: {
                return Flag.Default;
            }
            case Public: {
                return Flag.Public;
            }
            case Protected: {
                return Flag.Protected;
            }
            case Private: {
                return Flag.Private;
            }
            case Abstract: {
                return Flag.Abstract;
            }
            case Static: {
                return Flag.Static;
            }
            case Final: {
                return Flag.Final;
            }
            case Transient: {
                return Flag.Transient;
            }
            case Volatile: {
                return Flag.Volatile;
            }
            case Synchronized: {
                return Flag.Synchronized;
            }
            case Native: {
                return Flag.Native;
            }
            case Strictfp: {
                return Flag.Strictfp;
            }
        }
        return Flag.PotentiallyAmbiguous;
    }

    public static Collection<Flag> fromModifiers(Collection<J.Modifier> modifiers) {
        return modifiers.stream().map(J.Modifier::getType).map(FlagUtil::fromModifierType).collect(Collectors.toSet());
    }

    private FlagUtil() {
    }
}

