/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.search;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.controlflow.Guard;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.analysis.dataflow.LocalFlowSpec;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class UriCreatedWithHttpScheme
extends Recipe {
    private static final MethodMatcher URI_CREATE = new MethodMatcher("java.net.URI create(..)");
    private static final MethodMatcher STRING_REPLACE = new MethodMatcher("java.lang.String replace(..)");
    private static final LocalFlowSpec<J.Literal, Expression> INSECURE_URI_CREATE = new LocalFlowSpec<J.Literal, Expression>(){

        @Override
        public boolean isSource(J.Literal source, Cursor cursor) {
            return source.getValue() != null && source.getValue().toString().startsWith("http://");
        }

        @Override
        public boolean isSink(Expression sink, Cursor cursor) {
            J.MethodInvocation maybeMethodInvocation = (J.MethodInvocation)cursor.firstEnclosing(J.MethodInvocation.class);
            if (maybeMethodInvocation != null && URI_CREATE.matches(maybeMethodInvocation)) {
                return maybeMethodInvocation.getArguments().contains(sink);
            }
            return false;
        }

        @Override
        public boolean isAdditionalFlowStep(Expression srcExpression, Cursor srcCursor, Expression sinkExpression, Cursor sinkCursor) {
            if (sinkExpression instanceof J.Binary) {
                J.Binary endBinary = (J.Binary)sinkExpression;
                return srcExpression == endBinary.getLeft();
            }
            return false;
        }

        @Override
        public boolean isBarrierGuard(Guard guard, boolean branch) {
            return STRING_REPLACE.matches(guard.getExpression());
        }
    };

    public String getDisplayName() {
        return "URIs created with an HTTP scheme";
    }

    public String getDescription() {
        return "This is a sample recipe demonstrating a simple application of local data flow analysis.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(URI_CREATE), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J.Literal l = super.visitLiteral(literal, (Object)ctx);
                if (Dataflow.startingAt(this.getCursor()).findSinks(INSECURE_URI_CREATE).isPresent()) {
                    return l.withValue((Object)l.getValue().toString().replace("http://", "https://")).withValueSource(l.getValueSource().replace("http://", "https://"));
                }
                return l;
            }
        });
    }
}

