/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.util.Optional;
import java.util.function.Function;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.dataflow.ExpressionDataFlowNode;
import org.openrewrite.analysis.dataflow.ParameterDataFlowNode;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.analysis.trait.variable.Parameter;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public abstract class DataFlowNode {
    final Cursor cursor;

    abstract Optional<Expression> asExpression();

    abstract Optional<Parameter> asParameter();

    abstract <T> T map(Function<Expression, T> var1, Function<Parameter, T> var2);

    public static DataFlowNode of(Cursor cursor) {
        if (cursor.getValue() instanceof Expression) {
            return new ExpressionDataFlowNode(cursor, (Expression)cursor.getValue());
        }
        if (cursor.getValue() instanceof J.VariableDeclarations.NamedVariable) {
            return new ParameterDataFlowNode(cursor, (Parameter)Parameter.viewOf(cursor).on(TraitErrors::doThrow));
        }
        throw new IllegalArgumentException("DataFlowNode can not be of type: " + cursor.getValue().getClass());
    }

    DataFlowNode(Cursor cursor) {
        this.cursor = cursor;
    }
}

