/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.java.JavaParser;
import org.openrewrite.json.JsonParser;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.protobuf.ProtoParser;
import org.openrewrite.quark.QuarkParser;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class ResourceParser {
    private static final Set<String> DEFAULT_ACCEPTED_DIRECTORIES = new HashSet<String>(Collections.singleton("src"));
    private static final Set<String> DEFAULT_IGNORED_DIRECTORIES = new HashSet<String>(Arrays.asList("build", "target", "out", ".sonar", ".gradle", ".idea", ".project", "node_modules", ".git", ".metadata", ".DS_Store"));
    private final Path baseDir;
    private final Log logger;
    private final Collection<PathMatcher> exclusions;
    private final int sizeThresholdMb;
    private final Collection<Path> excludedDirectories;
    private final Collection<PathMatcher> plainTextMasks;
    private final JavaParser.Builder<? extends JavaParser, ?> javaParserBuilder;
    private final KotlinParser.Builder kotlinParserBuilder;
    private final ExecutionContext ctx;

    public ResourceParser(Path baseDir, Log logger, Collection<String> exclusions, Collection<String> plainTextMasks, int sizeThresholdMb, Collection<Path> excludedDirectories, JavaParser.Builder<? extends JavaParser, ?> javaParserBuilder, KotlinParser.Builder kotlinParserBuilder, ExecutionContext ctx) {
        this.baseDir = baseDir;
        this.logger = logger;
        this.javaParserBuilder = javaParserBuilder;
        this.kotlinParserBuilder = kotlinParserBuilder;
        this.exclusions = this.pathMatchers(baseDir, exclusions);
        this.sizeThresholdMb = sizeThresholdMb;
        this.excludedDirectories = excludedDirectories;
        this.plainTextMasks = this.pathMatchers(baseDir, plainTextMasks);
        this.ctx = ctx;
    }

    private Collection<PathMatcher> pathMatchers(Path basePath, Collection<String> pathExpressions) {
        return pathExpressions.stream().map(o -> basePath.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList());
    }

    public Stream<SourceFile> parse(Path searchDir, Collection<Path> alreadyParsed) {
        Stream<SourceFile> sourceFiles = Stream.empty();
        if (!searchDir.toFile().exists()) {
            return sourceFiles;
        }
        try {
            sourceFiles = Stream.concat(sourceFiles, this.parseSourceFiles(searchDir, alreadyParsed, this.ctx));
        }
        catch (IOException e) {
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
            throw new UncheckedIOException(e);
        }
        return sourceFiles;
    }

    public <S extends SourceFile> Stream<S> parseSourceFiles(final Path searchDir, final Collection<Path> alreadyParsed, ExecutionContext ctx) throws IOException {
        final ArrayList resources = new ArrayList();
        final ArrayList quarkPaths = new ArrayList();
        final ArrayList plainTextPaths = new ArrayList();
        Files.walkFileTree(searchDir, Collections.emptySet(), 16, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (ResourceParser.this.isExcluded(dir) || ResourceParser.this.isIgnoredDirectory(searchDir, dir) || ResourceParser.this.excludedDirectories.contains(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!(attrs.isOther() || attrs.isSymbolicLink() || alreadyParsed.contains(file) || ResourceParser.this.isExcluded(file))) {
                    if (ResourceParser.this.isOverSizeThreshold(attrs.size())) {
                        ResourceParser.this.logger.info((CharSequence)("Not parsing quark " + file + " as its size " + attrs.size() / 0x100000L + " MB exceeds size threshold " + ResourceParser.this.sizeThresholdMb + " MB"));
                        quarkPaths.add(file);
                    } else if (ResourceParser.this.isParsedAsPlainText(file)) {
                        plainTextPaths.add(file);
                    } else {
                        resources.add(file);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Stream sourceFiles = Stream.empty();
        JavaParser javaParser = this.javaParserBuilder.build();
        ArrayList javaPaths = new ArrayList();
        JsonParser jsonParser = new JsonParser();
        ArrayList jsonPaths = new ArrayList();
        XmlParser xmlParser = new XmlParser();
        ArrayList xmlPaths = new ArrayList();
        YamlParser yamlParser = new YamlParser();
        ArrayList yamlPaths = new ArrayList();
        PropertiesParser propertiesParser = new PropertiesParser();
        ArrayList propertiesPaths = new ArrayList();
        ProtoParser protoParser = new ProtoParser();
        ArrayList protoPaths = new ArrayList();
        KotlinParser kotlinParser = this.kotlinParserBuilder.build();
        ArrayList kotlinPaths = new ArrayList();
        GroovyParser groovyParser = GroovyParser.builder().build();
        ArrayList groovyPaths = new ArrayList();
        HclParser hclParser = HclParser.builder().build();
        ArrayList hclPaths = new ArrayList();
        PlainTextParser plainTextParser = new PlainTextParser();
        QuarkParser quarkParser = new QuarkParser();
        resources.forEach(path -> {
            if (javaParser.accept(path) && !path.endsWith(".qute.java")) {
                javaPaths.add(path);
            } else if (jsonParser.accept(path)) {
                jsonPaths.add(path);
            } else if (xmlParser.accept(path)) {
                xmlPaths.add(path);
            } else if (yamlParser.accept(path)) {
                yamlPaths.add(path);
            } else if (propertiesParser.accept(path)) {
                propertiesPaths.add(path);
            } else if (protoParser.accept(path)) {
                protoPaths.add(path);
            } else if (kotlinParser.accept(path)) {
                kotlinPaths.add(path);
            } else if (groovyParser.accept(path)) {
                groovyPaths.add(path);
            } else if (hclParser.accept(path)) {
                hclPaths.add(path);
            } else if (quarkParser.accept(path)) {
                quarkPaths.add(path);
            }
        });
        if (!javaPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, javaParser.parse(javaPaths, this.baseDir, ctx));
            alreadyParsed.addAll(javaPaths);
        }
        if (!jsonPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, jsonParser.parse(jsonPaths, this.baseDir, ctx));
            alreadyParsed.addAll(jsonPaths);
        }
        if (!xmlPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, xmlParser.parse(xmlPaths, this.baseDir, ctx));
            alreadyParsed.addAll(xmlPaths);
        }
        if (!yamlPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, yamlParser.parse(yamlPaths, this.baseDir, ctx));
            alreadyParsed.addAll(yamlPaths);
        }
        if (!propertiesPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, propertiesParser.parse(propertiesPaths, this.baseDir, ctx));
            alreadyParsed.addAll(propertiesPaths);
        }
        if (!protoPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, protoParser.parse(protoPaths, this.baseDir, ctx));
            alreadyParsed.addAll(protoPaths);
        }
        if (!kotlinPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, kotlinParser.parse(kotlinPaths, this.baseDir, ctx));
            alreadyParsed.addAll(kotlinPaths);
        }
        if (!groovyPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, groovyParser.parse(groovyPaths, this.baseDir, ctx));
            alreadyParsed.addAll(groovyPaths);
        }
        if (!hclPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, hclParser.parse(hclPaths, this.baseDir, ctx));
            alreadyParsed.addAll(hclPaths);
        }
        if (!plainTextPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, plainTextParser.parse(plainTextPaths, this.baseDir, ctx));
            alreadyParsed.addAll(plainTextPaths);
        }
        if (!quarkPaths.isEmpty()) {
            sourceFiles = Stream.concat(sourceFiles, quarkParser.parse(quarkPaths, this.baseDir, ctx));
            alreadyParsed.addAll(quarkPaths);
        }
        return sourceFiles;
    }

    private boolean isOverSizeThreshold(long fileSize) {
        return this.sizeThresholdMb > 0 && fileSize > (long)this.sizeThresholdMb * 1024L * 1024L;
    }

    private boolean isExcluded(Path path) {
        for (PathMatcher excluded : this.exclusions) {
            if (!excluded.matches(path)) continue;
            return true;
        }
        if (!path.isAbsolute() && !path.startsWith(File.separator)) {
            return this.isExcluded(Paths.get("/" + path, new String[0]));
        }
        return false;
    }

    private boolean isParsedAsPlainText(Path path) {
        if (!this.plainTextMasks.isEmpty()) {
            Path computed = this.baseDir.relativize(path);
            if (!computed.startsWith("/")) {
                computed = Paths.get("/", new String[0]).resolve(computed);
            }
            for (PathMatcher matcher : this.plainTextMasks) {
                if (!matcher.matches(computed)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIgnoredDirectory(Path searchDir, Path path) {
        for (Path pathSegment : searchDir.relativize(path)) {
            if (DEFAULT_ACCEPTED_DIRECTORIES.contains(pathSegment.toString())) {
                return false;
            }
            if (!DEFAULT_IGNORED_DIRECTORIES.contains(pathSegment.toString())) continue;
            return true;
        }
        return false;
    }
}

