/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Result;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AbstractRewriteBaseRunMojo;
import org.openrewrite.maven.ConfigurableRewriteMojo;
import org.openrewrite.maven.SanitizedMarkerPrinter;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;

public class AbstractRewriteRunMojo
extends AbstractRewriteBaseRunMojo {
    public void execute() throws MojoExecutionException {
        if (this.rewriteSkip) {
            this.getLog().info((CharSequence)"Skipping execution");
            this.putState(ConfigurableRewriteMojo.State.SKIPPED);
            return;
        }
        this.putState(ConfigurableRewriteMojo.State.TO_BE_PROCESSED);
        if (!this.runPerSubmodule && !this.allProjectsMarked()) {
            this.getLog().info((CharSequence)("REWRITE: Delaying execution to the end of multi-module project for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion()));
            return;
        }
        ExecutionContext ctx = this.executionContext();
        AbstractRewriteBaseRunMojo.ResultsContainer results = this.listResults(ctx);
        @Nullable RuntimeException firstException = results.getFirstException();
        if (firstException != null) {
            this.getLog().error((CharSequence)"The recipe produced an error. Please report this to the recipe author.");
            throw firstException;
        }
        if (results.isNotEmpty()) {
            Duration estimateTimeSaved = Duration.ZERO;
            for (Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("Generated new file " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
                estimateTimeSaved = this.estimateTimeSavedSum(result, estimateTimeSaved);
            }
            for (Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Deleted file " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
                estimateTimeSaved = this.estimateTimeSavedSum(result, estimateTimeSaved);
            }
            for (Result result : results.moved) {
                assert (result.getAfter() != null);
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("File has been moved from " + result.getBefore().getSourcePath().normalize() + " to " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
                estimateTimeSaved = this.estimateTimeSavedSum(result, estimateTimeSaved);
            }
            for (Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Changes have been made to " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
                estimateTimeSaved = this.estimateTimeSavedSum(result, estimateTimeSaved);
            }
            this.getLog().warn((CharSequence)"Please review and commit the results.");
            this.getLog().warn((CharSequence)("Estimate time saved: " + this.formatDuration(estimateTimeSaved)));
            try {
                Path originalLocation;
                for (Result result : results.generated) {
                    assert (result.getAfter() != null);
                    AbstractRewriteRunMojo.writeAfter(results.getProjectRoot(), result, ctx);
                }
                for (Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath()).normalize();
                    boolean deleteSucceeded = originalLocation.toFile().delete();
                    if (deleteSucceeded) continue;
                    throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                }
                for (Result result : results.moved) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                    File originalParentDir = originalLocation.toFile().getParentFile();
                    assert (result.getAfter() != null);
                    Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                    File afterParentDir = afterLocation.toFile().getParentFile();
                    if (afterParentDir.exists() && afterParentDir.getAbsolutePath().equalsIgnoreCase(originalParentDir.getAbsolutePath()) && !afterParentDir.getAbsolutePath().equals(originalParentDir.getAbsolutePath())) {
                        if (!originalParentDir.renameTo(afterParentDir)) {
                            throw new RuntimeException("Unable to rename directory from " + originalParentDir.getAbsolutePath() + " To: " + afterParentDir.getAbsolutePath());
                        }
                    } else if (!afterParentDir.exists() && !afterParentDir.mkdirs()) {
                        throw new RuntimeException("Unable to create directory " + afterParentDir.getAbsolutePath());
                    }
                    if (result.getAfter() instanceof Quark) {
                        Files.move(originalLocation, results.getProjectRoot().resolve(result.getAfter().getSourcePath()), new CopyOption[0]);
                        continue;
                    }
                    originalLocation.toFile().delete();
                    AbstractRewriteRunMojo.writeAfter(results.getProjectRoot(), result, ctx);
                }
                for (Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    assert (result.getAfter() != null);
                    AbstractRewriteRunMojo.writeAfter(results.getProjectRoot(), result, ctx);
                }
                List<Path> emptyDirectories = results.newlyEmptyDirectories();
                if (!emptyDirectories.isEmpty()) {
                    this.getLog().info((CharSequence)("Removing " + emptyDirectories.size() + " newly empty directories:"));
                    for (Path emptyDirectory : emptyDirectories) {
                        this.getLog().info((CharSequence)("  " + emptyDirectory));
                        Files.delete(emptyDirectory);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to rewrite source files", e);
            }
        }
        this.putState(ConfigurableRewriteMojo.State.PROCESSED);
    }

    private static void writeAfter(Path root, Result result, ExecutionContext ctx) {
        File targetFile;
        block32: {
            if (result.getAfter() == null || result.getAfter() instanceof Quark) {
                return;
            }
            Path targetPath = root.resolve(result.getAfter().getSourcePath());
            targetFile = targetPath.toFile();
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (result.getAfter() instanceof Binary) {
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    sourceFileWriter.write(((Binary)result.getAfter()).getBytes());
                    break block32;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (result.getAfter() instanceof Remote) {
                Remote remote = (Remote)result.getAfter();
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    int length;
                    InputStream source = remote.getInputStream(ctx);
                    byte[] buf = new byte[4096];
                    while ((length = source.read(buf)) > 0) {
                        sourceFileWriter.write(buf, 0, length);
                    }
                    break block32;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (!(result.getAfter() instanceof Quark)) {
                Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
                try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(targetPath, charset, new OpenOption[0]);){
                    sourceFileWriter.write(result.getAfter().printAll(new PrintOutputCapture((Object)0, (PrintOutputCapture.MarkerPrinter)new SanitizedMarkerPrinter())));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
        }
        if (result.getAfter().getFileAttributes() != null) {
            FileAttributes fileAttributes = result.getAfter().getFileAttributes();
            if (targetFile.canRead() != fileAttributes.isReadable()) {
                targetFile.setReadable(fileAttributes.isReadable());
            }
            if (targetFile.canWrite() != fileAttributes.isWritable()) {
                targetFile.setWritable(fileAttributes.isWritable());
            }
            if (targetFile.canExecute() != fileAttributes.isExecutable()) {
                targetFile.setExecutable(fileAttributes.isExecutable());
            }
        }
    }
}

