/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.puppycrawl.tools.checkstyle.Checker;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.style.NamedStyles;

public abstract class ConfigurableRewriteMojo
extends AbstractMojo {
    @Parameter(property="rewrite.configLocation", alias="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    protected String configLocation;
    @Nullable
    @Parameter(property="rewrite.activeRecipes")
    protected LinkedHashSet<String> activeRecipes;
    @Nullable
    @Deprecated
    @Parameter(property="activeRecipes")
    protected LinkedHashSet<String> deprecatedActiveRecipes;
    @Nullable
    @Parameter(property="rewrite.activeStyles")
    protected LinkedHashSet<String> activeStyles;
    @Nullable
    @Deprecated
    @Parameter(property="activeStyles")
    protected LinkedHashSet<String> deprecatedActiveStyles;
    @Nullable
    @Parameter(property="rewrite.metricsUri", alias="metricsUri")
    protected String metricsUri;
    @Nullable
    @Parameter(property="rewrite.metricsUsername", alias="metricsUsername")
    protected String metricsUsername;
    @Nullable
    @Parameter(property="rewrite.metricsPassword", alias="metricsPassword")
    protected String metricsPassword;
    @Parameter(property="rewrite.pomCacheEnabled", alias="pomCacheEnabled", defaultValue="true")
    protected boolean pomCacheEnabled;
    @Nullable
    @Parameter(property="rewrite.pomCacheDirectory", alias="pomCacheDirectory")
    protected String pomCacheDirectory;
    @Parameter(property="rewrite.skip", defaultValue="false")
    protected boolean rewriteSkip;
    @Parameter(property="skipMavenParsing", defaultValue="false")
    protected boolean skipMavenParsing;
    @Nullable
    @Parameter(property="rewrite.checkstyleConfigFile", alias="checkstyleConfigFile")
    protected String checkstyleConfigFile;
    @Nullable
    @Parameter(property="rewrite.checkstyleDetectionEnabled", alias="checkstyleDetectionEnabled", defaultValue="true")
    protected boolean checkstyleDetectionEnabled;
    @Nullable
    @Parameter(property="rewrite.exclusions")
    private LinkedHashSet<String> exclusions;
    @Nullable
    @Deprecated
    @Parameter(property="exclusions")
    private LinkedHashSet<String> deprecatedExclusions;
    @Nullable
    @Parameter(property="rewrite.plainTextMasks")
    private LinkedHashSet<String> plainTextMasks;
    @Nullable
    @Deprecated
    @Parameter(property="plainTextMasks")
    private LinkedHashSet<String> deprecatedPlainTextMasks;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(property="rewrite.failOnInvalidActiveRecipes", alias="failOnInvalidActiveRecipes", defaultValue="false")
    protected boolean failOnInvalidActiveRecipes;
    @Parameter(property="rewrite.runPerSubmodule", alias="runPerSubmodule", defaultValue="false")
    protected boolean runPerSubmodule;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    protected PluginDescriptor pluginDescriptor;
    private static final String OPENREWRITE_PROCESSED_MARKER = "openrewrite.processed";
    @Nullable
    @Parameter(property="rewrite.recipeArtifactCoordinates")
    private LinkedHashSet<String> recipeArtifactCoordinates;
    @Nullable
    private volatile Set<String> computedRecipes;
    @Nullable
    private volatile Set<String> computedStyles;
    @Nullable
    private volatile Set<String> computedRecipeArtifactCoordinates;

    protected Set<String> getExclusions() {
        return ConfigurableRewriteMojo.getMergedAndCleaned(this.exclusions, this.deprecatedExclusions);
    }

    protected Set<String> getPlainTextMasks() {
        Set<String> masks = ConfigurableRewriteMojo.getMergedAndCleaned(this.plainTextMasks, this.deprecatedPlainTextMasks);
        if (!masks.isEmpty()) {
            return masks;
        }
        return new HashSet<String>(Arrays.asList("**/*.adoc", "**/*.bash", "**/*.bat", "**/CODEOWNERS", "**/*.css", "**/*.config", "**/Dockerfile*", "**/.gitattributes", "**/.gitignore", "**/*.htm*", "**/gradlew", "**/.java-version", "**/*.jsp", "**/*.ksh", "**/lombok.config", "**/*.md", "**/*.mf", "**/META-INF/services/**", "**/META-INF/spring/**", "**/META-INF/spring.factories", "**/mvnw", "**/mvnw.cmd", "**/*.qute.java", "**/.sdkmanrc", "**/*.sh", "**/*.sql", "**/*.svg", "**/*.txt", "**/*.py"));
    }

    protected void putState(State state) {
        this.getPluginContext().put(OPENREWRITE_PROCESSED_MARKER, state.name());
    }

    private boolean hasState(MavenProject project) {
        Map pluginContext = this.mavenSession.getPluginContext(this.pluginDescriptor, project);
        return pluginContext.containsKey(OPENREWRITE_PROCESSED_MARKER);
    }

    protected boolean allProjectsMarked() {
        return this.mavenSession.getProjects().stream().allMatch(this::hasState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveRecipes() {
        if (this.computedRecipes == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipes == null) {
                    this.computedRecipes = ConfigurableRewriteMojo.getMergedAndCleaned(this.activeRecipes, this.deprecatedActiveRecipes);
                }
            }
        }
        return this.computedRecipes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveStyles() {
        if (this.computedStyles == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedStyles == null) {
                    this.computedStyles = ConfigurableRewriteMojo.getMergedAndCleaned(this.activeStyles, this.deprecatedActiveStyles);
                }
            }
        }
        return this.computedStyles;
    }

    protected List<NamedStyles> loadStyles(MavenProject project, Environment env) {
        List styles;
        block12: {
            styles = env.activateStyles(this.getActiveStyles());
            try {
                Object checkstyleConfRaw;
                Plugin checkstylePlugin = project.getPlugin("org.apache.maven.plugins:maven-checkstyle-plugin");
                if (this.checkstyleConfigFile != null && !this.checkstyleConfigFile.isEmpty()) {
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)Paths.get(this.checkstyleConfigFile, new String[0]), Collections.emptyMap()));
                    break block12;
                }
                if (!this.checkstyleDetectionEnabled || checkstylePlugin == null || !((checkstyleConfRaw = checkstylePlugin.getConfiguration()) instanceof Xpp3Dom)) break block12;
                Xpp3Dom xmlCheckstyleConf = (Xpp3Dom)checkstyleConfRaw;
                Xpp3Dom xmlConfigLocation = xmlCheckstyleConf.getChild("configLocation");
                if (xmlConfigLocation == null) {
                    try (InputStream is = Checker.class.getResourceAsStream("/sun_checks.xml");){
                        if (is != null) {
                            styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((InputStream)is, Collections.emptyMap()));
                        }
                        break block12;
                    }
                }
                Path configPath = Paths.get(checkstylePlugin.getLocation((Object)"").getSource().getLocation(), new String[0]).resolveSibling(xmlConfigLocation.getValue());
                if (configPath.toFile().exists()) {
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)configPath, Collections.emptyMap()));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Unable to parse checkstyle configuration. Checkstyle will not inform rewrite execution.", (Throwable)e);
            }
        }
        return styles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getRecipeArtifactCoordinates() {
        if (this.computedRecipeArtifactCoordinates == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipeArtifactCoordinates == null) {
                    this.computedRecipeArtifactCoordinates = ConfigurableRewriteMojo.getMergedAndCleaned(this.recipeArtifactCoordinates, null);
                }
            }
        }
        return this.computedRecipeArtifactCoordinates;
    }

    private static Set<String> getMergedAndCleaned(@Nullable LinkedHashSet<String> set, @Nullable LinkedHashSet<String> deprecatedSet) {
        Stream<Object> merged = Stream.empty();
        if (set != null) {
            merged = set.stream();
        }
        if (deprecatedSet != null) {
            merged = Stream.concat(merged, deprecatedSet.stream());
        }
        LinkedHashSet collected = merged.filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(collected);
    }

    protected static enum State {
        SKIPPED,
        PROCESSED,
        TO_BE_PROCESSED;

    }
}

