/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.maven.utilities.PrintMavenAsCycloneDxBom;
import org.openrewrite.xml.tree.Xml;

@Mojo(name="cyclonedx", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class CycloneDxBomMojo
extends AbstractRewriteMojo {
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        ExecutionContext ctx = this.executionContext();
        Path baseDir = this.getBuildRoot();
        Xml.Document maven = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, this.getExclusions(), this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter).parseMaven(this.project, Collections.emptyList(), ctx);
        if (maven != null) {
            File cycloneDxBom = this.buildCycloneDxBom(maven);
            this.projectHelper.attachArtifact(this.project, "xml", "cyclonedx", cycloneDxBom);
        } else {
            this.getLog().error((CharSequence)"No cyclonedx bom produced");
        }
    }

    @Nullable
    private File buildCycloneDxBom(Xml.Document pomAst) {
        try {
            File cycloneDxBom = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-cyclonedx.xml");
            cycloneDxBom.getParentFile().mkdirs();
            Files.write(cycloneDxBom.toPath(), PrintMavenAsCycloneDxBom.print((Xml.Document)pomAst).getBytes(pomAst.getCharset()), new OpenOption[0]);
            return cycloneDxBom;
        }
        catch (Throwable t) {
            this.getLog().warn((CharSequence)"Unable to produce CycloneDX BOM", t);
            return null;
        }
    }
}

