/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.openrewrite.FileAttributes;
import org.openrewrite.Result;
import org.openrewrite.binary.Binary;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;

public class AbstractRewriteRunMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        if (!this.runPerSubmodule && !this.project.getId().equals(((MavenProject)this.mavenSession.getProjects().get(this.mavenSession.getProjects().size() - 1)).getId())) {
            return;
        }
        AbstractRewriteMojo.ResultsContainer results = this.listResults();
        if (results.isNotEmpty()) {
            for (Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("Generated new file " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Deleted file " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.moved) {
                assert (result.getAfter() != null);
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("File has been moved from " + result.getBefore().getSourcePath().normalize() + " to " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Changes have been made to " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            this.getLog().warn((CharSequence)"Please review and commit the results.");
            try {
                Path originalLocation;
                for (Result result : results.generated) {
                    assert (result.getAfter() != null);
                    AbstractRewriteRunMojo.writeAfter(results.getProjectRoot(), result);
                }
                for (Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath()).normalize();
                    boolean deleteSucceeded = originalLocation.toFile().delete();
                    if (deleteSucceeded) continue;
                    throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                }
                for (Result result : results.moved) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                    File originalParentDir = originalLocation.toFile().getParentFile();
                    assert (result.getAfter() != null);
                    Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                    File afterParentDir = afterLocation.toFile().getParentFile();
                    if (afterParentDir.exists() && afterParentDir.getAbsolutePath().equalsIgnoreCase(originalParentDir.getAbsolutePath()) && !afterParentDir.getAbsolutePath().equals(originalParentDir.getAbsolutePath())) {
                        if (!originalParentDir.renameTo(afterParentDir)) {
                            throw new RuntimeException("Unable to rename directory from " + originalParentDir.getAbsolutePath() + " To: " + afterParentDir.getAbsolutePath());
                        }
                    } else if (!afterParentDir.exists() && !afterParentDir.mkdirs()) {
                        throw new RuntimeException("Unable to create directory " + afterParentDir.getAbsolutePath());
                    }
                    if (result.getAfter() instanceof Quark) {
                        Files.move(originalLocation, results.getProjectRoot().resolve(result.getAfter().getSourcePath()), new CopyOption[0]);
                        continue;
                    }
                    originalLocation.toFile().delete();
                    AbstractRewriteRunMojo.writeAfter(results.getProjectRoot(), result);
                }
                for (Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    assert (result.getAfter() != null);
                    AbstractRewriteRunMojo.writeAfter(results.getProjectRoot(), result);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to rewrite source files", e);
            }
        }
    }

    private static void writeAfter(Path root, Result result) {
        File targetFile;
        block31: {
            assert (result.getAfter() != null);
            Path targetPath = root.resolve(result.getAfter().getSourcePath());
            targetFile = targetPath.toFile();
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (result.getAfter() instanceof Binary) {
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    sourceFileWriter.write(((Binary)result.getAfter()).getBytes());
                    break block31;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            if (result.getAfter() instanceof Remote) {
                Remote remote = (Remote)result.getAfter();
                try (FileOutputStream sourceFileWriter = new FileOutputStream(targetFile);){
                    int length;
                    InputStream source = remote.getInputStream((HttpSender)new HttpUrlConnectionSender());
                    byte[] buf = new byte[4096];
                    while ((length = source.read(buf)) > 0) {
                        sourceFileWriter.write(buf, 0, length);
                    }
                    break block31;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to rewrite source files", e);
                }
            }
            Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
            try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(targetPath, charset, new OpenOption[0]);){
                sourceFileWriter.write(new String(result.getAfter().printAll().getBytes(charset), charset));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to rewrite source files", e);
            }
        }
        if (result.getAfter().getFileAttributes() != null) {
            FileAttributes fileAttributes = result.getAfter().getFileAttributes();
            if (targetFile.canRead() != fileAttributes.isReadable()) {
                targetFile.setReadable(fileAttributes.isReadable());
            }
            if (targetFile.canWrite() != fileAttributes.isWritable()) {
                targetFile.setWritable(fileAttributes.isWritable());
            }
            if (targetFile.canExecute() != fileAttributes.isExecutable()) {
                targetFile.setExecutable(fileAttributes.isExecutable());
            }
        }
    }
}

