/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Result;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenOptsHelper;

@Mojo(name="dryRun", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class RewriteDryRunMojo
extends AbstractRewriteMojo {
    @Parameter(property="reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}/rewrite")
    private File reportOutputDirectory;
    @Parameter(property="failOnDryRunResults", defaultValue="false")
    private boolean failOnDryRunResults;

    public void execute() throws MojoExecutionException {
        MavenOptsHelper.checkAndLogMissingJvmModuleExports(this.getLog());
        AbstractRewriteMojo.ResultsContainer results = this.listResults();
        if (results.isNotEmpty()) {
            for (Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("These recipes would generate new file " + result.getAfter().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("These recipes would delete file " + result.getBefore().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.moved) {
                assert (result.getBefore() != null);
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("These recipes would move file from " + result.getBefore().getSourcePath() + " to " + result.getAfter().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("These recipes would make changes to " + result.getBefore().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            this.reportOutputDirectory.mkdirs();
            Path patchFile = this.reportOutputDirectory.toPath().resolve("rewrite.patch");
            try (BufferedWriter writer = Files.newBufferedWriter(patchFile, new OpenOption[0]);){
                Stream.concat(Stream.concat(results.generated.stream(), results.deleted.stream()), Stream.concat(results.moved.stream(), results.refactoredInPlace.stream())).map(Result::diff).forEach(diff -> {
                    try {
                        writer.write(diff + "\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to generate rewrite result.", e);
            }
            this.getLog().warn((CharSequence)"Patch file available:");
            this.getLog().warn((CharSequence)("    " + patchFile.normalize()));
            this.getLog().warn((CharSequence)"Run 'mvn rewrite:run' to apply the recipes.");
            if (this.failOnDryRunResults) {
                throw new MojoExecutionException("Applying recipes would make changes. See logs for more details.");
            }
        } else {
            this.getLog().info((CharSequence)"Applying recipes would make no changes. No patch file generated.");
        }
    }
}

