/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.json.JsonParser;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class ResourceParser {
    private final Log logger;
    private final Collection<String> exclusions;
    private final int sizeThresholdMb;

    public ResourceParser(Log logger, Collection<String> exclusions, int thresholdMb) {
        this.logger = logger;
        this.exclusions = exclusions;
        this.sizeThresholdMb = thresholdMb;
    }

    public List<SourceFile> parse(Path baseDir, Path searchDir, Collection<Path> alreadyParsed) {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        if (!searchDir.toFile().exists()) {
            return sourceFiles;
        }
        Consumer<Throwable> errorConsumer = t -> this.logger.error((CharSequence)"Error parsing", t);
        InMemoryExecutionContext ctx = new InMemoryExecutionContext(errorConsumer);
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new JsonParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new XmlParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new YamlParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new PropertiesParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)HclParser.builder().build(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        return sourceFiles;
    }

    public <S extends SourceFile> List<S> parseSourceFiles(Path baseDir, Parser<S> parser, Path searchDir, Collection<Path> alreadyParsed, ExecutionContext ctx) {
        List sources;
        BiPredicate<Path, BasicFileAttributes> sourceMatcher = (path, attrs) -> {
            if (path.toString().contains("/target/") || path.toString().contains("/build/") || path.toString().contains("/out/") || path.toString().contains("/node_modules/") || path.toString().contains("/.metadata/")) {
                return false;
            }
            for (String exclusion : this.exclusions) {
                PathMatcher matcher = baseDir.getFileSystem().getPathMatcher("glob:" + exclusion);
                if (!matcher.matches(baseDir.relativize((Path)path))) continue;
                return false;
            }
            if (alreadyParsed.contains(searchDir.relativize((Path)path))) {
                return false;
            }
            if (attrs.isDirectory() || attrs.size() == 0L) {
                return false;
            }
            if (this.sizeThresholdMb > 0 && attrs.size() > (long)this.sizeThresholdMb * 1024L * 1024L) {
                alreadyParsed.add((Path)path);
                this.logger.info((CharSequence)("Skipping parsing " + path + " as its size + " + attrs.size() / 0x100000L + "Mb exceeds size threshold " + this.sizeThresholdMb + "Mb"));
                return false;
            }
            return parser.accept(path);
        };
        try (Stream<Path> files = Files.find(searchDir, 16, sourceMatcher, new FileVisitOption[0]);){
            sources = files.collect(Collectors.toList());
        }
        catch (IOException e) {
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
            throw new UncheckedIOException(e);
        }
        return parser.parse(sources, baseDir, ctx);
    }
}

