/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Result;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="diff", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class RewriteDiffMojo
extends AbstractRewriteMojo {
    @Parameter(property="reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}/rewrite", required=true)
    private File reportOutputDirectory;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;

    public void execute() throws MojoExecutionException {
        AbstractRewriteMojo.ResultsContainer changes = this.listResults();
        if (changes.isNotEmpty()) {
            for (Result change : changes.generated) {
                this.getLog().warn((CharSequence)("Applying patch would generate new file " + change.getAfter().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(change);
            }
            for (Result change : changes.deleted) {
                this.getLog().warn((CharSequence)("Applying patch would delete file " + change.getBefore().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(change);
            }
            for (Result change : changes.moved) {
                this.getLog().warn((CharSequence)("Applying patch would move file from " + change.getBefore().getSourcePath() + " to " + change.getAfter().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(change);
            }
            for (Result change : changes.refactoredInPlace) {
                this.getLog().warn((CharSequence)("Applying patch would make changes to " + change.getBefore().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(change);
            }
            this.reportOutputDirectory.mkdirs();
            Path patchFile = this.reportOutputDirectory.toPath().resolve("rewrite.patch");
            try (BufferedWriter writer = Files.newBufferedWriter(patchFile, new OpenOption[0]);){
                Stream.concat(Stream.concat(changes.generated.stream(), changes.deleted.stream()), Stream.concat(changes.moved.stream(), changes.refactoredInPlace.stream())).map(Result::diff).forEach(diff -> {
                    try {
                        writer.write(diff + "\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to generate rewrite diff file.", e);
            }
            this.getLog().warn((CharSequence)("A patch file has been generated. Run 'git apply " + Paths.get(this.mavenSession.getExecutionRootDirectory(), new String[0]).relativize(patchFile).toString() + "' to apply."));
        }
    }
}

