/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openrewrite.Change;
import org.openrewrite.Environment;
import org.openrewrite.Refactor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.java.JavaParser;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MeterRegistryProvider;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.yaml.YamlParser;

public abstract class AbstractRewriteMojo
extends AbstractMojo {
    @Parameter(property="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    String configLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="activeRecipes")
    protected Set<String> activeRecipes;
    @Parameter(property="activeStyles")
    Set<String> activeStyles;
    @Parameter(property="metricsUri")
    private String metricsUri;
    @Parameter(property="metricsUsername")
    private String metricsUsername;
    @Parameter(property="metricsPassword")
    private String metricsPassword;

    protected Environment environment() throws MojoExecutionException {
        Environment.Builder env;
        block16: {
            File rewriteConfig;
            env = Environment.builder((Properties)this.project.getProperties()).scanClasspath((Iterable)this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList()), new String[0]).scanUserHome();
            Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
            if (!absoluteConfigLocation.isAbsolute()) {
                absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
            }
            if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
                try (FileInputStream is = new FileInputStream(rewriteConfig);){
                    env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
                    break block16;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
                }
            }
            throw new MojoExecutionException("Unable to load rewrite configuration, because it does not exist: " + rewriteConfig.toString());
        }
        return env.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<Change> listChanges() throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            MeterRegistry meterRegistry = meterRegistryProvider.registry();
            if (this.activeRecipes == null || this.activeRecipes.isEmpty()) {
                List<Change> list = Collections.emptyList();
                return list;
            }
            Environment env = this.environment();
            Collection visitors = env.visitors(this.activeRecipes);
            ArrayList<Maven.Pom> sourceFiles = new ArrayList<Maven.Pom>();
            ArrayList<Path> javaSources = new ArrayList<Path>();
            javaSources.addAll(this.listJavaSources(this.project.getBuild().getSourceDirectory()));
            javaSources.addAll(this.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
            sourceFiles.addAll(JavaParser.fromJavaVersion().styles((Iterable)env.styles(this.activeStyles)).classpath((Collection)this.project.getCompileClasspathElements().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList())).logCompilationWarningsAndErrors(false).meterRegistry(meterRegistry).build().parse(javaSources, this.project.getBasedir().toPath()));
            sourceFiles.addAll(new YamlParser().parse((Iterable)Stream.concat(this.project.getBuild().getResources().stream(), this.project.getBuild().getTestResources().stream()).map(Resource::getTargetPath).filter(Objects::nonNull).filter(it -> it.endsWith(".yml") || it.endsWith(".yaml")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()), this.project.getBasedir().toPath()));
            sourceFiles.addAll(new PropertiesParser().parse((Iterable)Stream.concat(this.project.getBuild().getResources().stream(), this.project.getBuild().getTestResources().stream()).map(Resource::getTargetPath).filter(Objects::nonNull).filter(it -> it.endsWith(".properties")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()), this.project.getBasedir().toPath()));
            ArrayList<Path> allPoms = new ArrayList<Path>();
            allPoms.add(this.project.getFile().toPath());
            if (this.project.getCollectedProjects() != null) {
                this.project.getCollectedProjects().stream().filter(collectedProject -> collectedProject != this.project).map(collectedProject -> collectedProject.getFile().toPath()).forEach(allPoms::add);
            }
            for (MavenProject parent = this.project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
                allPoms.add(parent.getFile().toPath());
            }
            Maven.Pom pomAst = (Maven.Pom)MavenParser.builder().resolveDependencies(false).build().parse(allPoms, this.project.getBasedir().toPath()).iterator().next();
            pomAst = pomAst.withModel(pomAst.getModel().withTransitiveDependenciesByScope(this.project.getDependencies().stream().collect(Collectors.groupingBy(Dependency::getScope, Collectors.mapping(dep -> new MavenModel.ModuleVersionId(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getVersion(), "jar"), Collectors.toSet())))));
            sourceFiles.add(pomAst);
            Collection collection = new Refactor().visit((Iterable)visitors).setMeterRegistry(meterRegistry).fix(sourceFiles);
            return collection;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e));
        }
    }

    protected List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists()) {
            return Collections.emptyList();
        }
        Path sourceRoot = sourceDirectoryFile.toPath();
        try {
            return Files.walk(sourceRoot, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".java")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
        }
    }
}

