/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Change;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="fix", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_SOURCES)
public class RewriteFixMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        Collection<Change> changes = this.listChanges();
        if (!changes.isEmpty()) {
            for (Change change : changes) {
                this.getLog().warn((CharSequence)("Changes have been made to " + change.getOriginal().getSourcePath() + " by:"));
                for (String rule : change.getRulesThatMadeChanges()) {
                    this.getLog().warn((CharSequence)("   " + rule));
                }
            }
            this.getLog().warn((CharSequence)"Please review and commit the changes.");
            try {
                for (Change change : changes) {
                    BufferedWriter sourceFileWriter = Files.newBufferedWriter(this.project.getBasedir().toPath().resolve(change.getOriginal().getSourcePath()), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        sourceFileWriter.write(change.getFixed().print());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        if (throwable != null) {
                            try {
                                sourceFileWriter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        sourceFileWriter.close();
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to rewrite source files", (Exception)e);
            }
        }
    }
}

