/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.RecipeSerializer;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelProxy;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;

public final class OpenRewriteModel {
    private static final ObjectMapper mapper = new RecipeSerializer().getMapper();
    private final GradleProject gradleProject;
    private final @Nullable GradleSettings gradleSettings;

    public static OpenRewriteModel from(OpenRewriteModelProxy proxy) {
        try {
            GradleProject project = (GradleProject)mapper.readValue(proxy.getGradleProjectBytes(), GradleProject.class);
            GradleSettings settings = proxy.getGradleSettingsBytes() == null ? null : (GradleSettings)mapper.readValue(proxy.getGradleSettingsBytes(), GradleSettings.class);
            OpenRewriteModel.deduplicate(project, settings);
            return new OpenRewriteModel(project, settings);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void deduplicate(GradleProject gp, @Nullable GradleSettings gs) {
        HashMap<String, GradleDependencyConfiguration> configurationCache = new HashMap<String, GradleDependencyConfiguration>();
        OpenRewriteModel.deduplicateConfigurations(gp.getConfigurations(), configurationCache);
        OpenRewriteModel.deduplicateConfigurations(gp.getBuildscript().getConfigurations(), configurationCache);
    }

    private static void deduplicateConfigurations(List<GradleDependencyConfiguration> configurations, Map<String, GradleDependencyConfiguration> cache) {
        for (GradleDependencyConfiguration conf : configurations) {
            cache.putIfAbsent(conf.getName(), conf);
        }
        for (GradleDependencyConfiguration conf : configurations) {
            List deduplicatedExtendsFrom = ListUtils.map((List)conf.getExtendsFrom(), it -> {
                assert (it != null);
                return cache.getOrDefault(it.getName(), (GradleDependencyConfiguration)it);
            });
            conf.unsafeSetExtendsFrom(deduplicatedExtendsFrom);
        }
    }

    @Generated
    public OpenRewriteModel(GradleProject gradleProject, @Nullable GradleSettings gradleSettings) {
        this.gradleProject = gradleProject;
        this.gradleSettings = gradleSettings;
    }

    @Generated
    public GradleProject getGradleProject() {
        return this.gradleProject;
    }

    @Generated
    public @Nullable GradleSettings getGradleSettings() {
        return this.gradleSettings;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenRewriteModel)) {
            return false;
        }
        OpenRewriteModel other = (OpenRewriteModel)o;
        GradleProject this$gradleProject = this.getGradleProject();
        GradleProject other$gradleProject = other.getGradleProject();
        if (this$gradleProject == null ? other$gradleProject != null : !this$gradleProject.equals(other$gradleProject)) {
            return false;
        }
        GradleSettings this$gradleSettings = this.getGradleSettings();
        GradleSettings other$gradleSettings = other.getGradleSettings();
        return !(this$gradleSettings == null ? other$gradleSettings != null : !this$gradleSettings.equals(other$gradleSettings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GradleProject $gradleProject = this.getGradleProject();
        result = result * 59 + ($gradleProject == null ? 43 : $gradleProject.hashCode());
        GradleSettings $gradleSettings = this.getGradleSettings();
        result = result * 59 + ($gradleSettings == null ? 43 : $gradleSettings.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "OpenRewriteModel(gradleProject=" + this.getGradleProject() + ", gradleSettings=" + this.getGradleSettings() + ")";
    }
}

