/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.toolingapi.Dependency;
import org.openrewrite.gradle.toolingapi.GroupArtifactVersion;
import org.openrewrite.gradle.toolingapi.ResolvedDependency;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public final class GradleDependencyConfiguration
implements Serializable {
    private final String name;
    @Nullable
    private final String description;
    private final boolean isTransitive;
    private final boolean isCanBeResolved;
    private final boolean isCanBeConsumed;
    private List<GradleDependencyConfiguration> extendsFrom;
    private final List<org.openrewrite.maven.tree.Dependency> requested;
    private final List<org.openrewrite.maven.tree.ResolvedDependency> directResolved;
    private final List<org.openrewrite.maven.tree.ResolvedDependency> resolved;
    @Nullable
    private final String exceptionType;
    @Nullable
    private final String message;

    public List<GradleDependencyConfiguration> allExtendsFrom() {
        LinkedHashSet<GradleDependencyConfiguration> result = new LinkedHashSet<GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration parentConfiguration : this.getExtendsFrom()) {
            result.add(parentConfiguration);
            result.addAll(parentConfiguration.allExtendsFrom());
        }
        return new ArrayList<GradleDependencyConfiguration>(result);
    }

    @Nullable
    public org.openrewrite.maven.tree.Dependency findRequestedDependency(String groupId, String artifactId) {
        return this.requested.stream().filter(d -> StringUtils.matchesGlob((String)d.getGav().getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)d.getGav().getArtifactId(), (String)artifactId)).findFirst().orElse(null);
    }

    @Nullable
    public org.openrewrite.maven.tree.ResolvedDependency findResolvedDependency(String groupId, String artifactId) {
        return this.resolved.stream().map(d -> d.findDependency(groupId, artifactId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Map<String, GradleDependencyConfiguration> fromToolingModel(Map<String, org.openrewrite.gradle.toolingapi.GradleDependencyConfiguration> toolingConfigurations) {
        HashMap<String, GradleDependencyConfiguration> results = new HashMap<String, GradleDependencyConfiguration>();
        ArrayList<org.openrewrite.gradle.toolingapi.GradleDependencyConfiguration> configurations = new ArrayList<org.openrewrite.gradle.toolingapi.GradleDependencyConfiguration>(toolingConfigurations.values());
        for (org.openrewrite.gradle.toolingapi.GradleDependencyConfiguration toolingConfiguration : configurations) {
            GradleDependencyConfiguration configuration = GradleDependencyConfiguration.fromToolingModel(toolingConfiguration);
            results.put(configuration.getName(), configuration);
        }
        for (org.openrewrite.gradle.toolingapi.GradleDependencyConfiguration conf : configurations) {
            GradleDependencyConfiguration dc;
            if (conf.getExtendsFrom().isEmpty() || (dc = (GradleDependencyConfiguration)results.get(conf.getName())) == null) continue;
            List<GradleDependencyConfiguration> extendsFrom = conf.getExtendsFrom().stream().map(it -> (GradleDependencyConfiguration)results.get(it.getName())).collect(Collectors.toList());
            dc.unsafeSetExtendsFrom(extendsFrom);
        }
        return results;
    }

    private static GradleDependencyConfiguration fromToolingModel(org.openrewrite.gradle.toolingapi.GradleDependencyConfiguration config) {
        List<org.openrewrite.maven.tree.ResolvedDependency> direct = config.getResolved().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList());
        List<org.openrewrite.maven.tree.ResolvedDependency> transitive = GradleDependencyConfiguration.resolveTransitiveDependencies(direct, new LinkedHashSet<org.openrewrite.maven.tree.ResolvedDependency>());
        return new GradleDependencyConfiguration(config.getName(), config.getDescription(), config.isTransitive(), config.isCanBeResolved(), config.isCanBeConsumed(), Collections.emptyList(), config.getRequested().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList()), direct, transitive, null, null);
    }

    static List<org.openrewrite.maven.tree.ResolvedDependency> resolveTransitiveDependencies(List<org.openrewrite.maven.tree.ResolvedDependency> resolved, Set<org.openrewrite.maven.tree.ResolvedDependency> alreadyResolved) {
        for (org.openrewrite.maven.tree.ResolvedDependency dependency : resolved) {
            if (!alreadyResolved.add(dependency)) continue;
            alreadyResolved.addAll(GradleDependencyConfiguration.resolveTransitiveDependencies(dependency.getDependencies(), alreadyResolved));
        }
        return new ArrayList<org.openrewrite.maven.tree.ResolvedDependency>(alreadyResolved);
    }

    void unsafeSetExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        this.extendsFrom = extendsFrom;
    }

    private static org.openrewrite.maven.tree.ResolvedDependency fromToolingModel(ResolvedDependency dep) {
        return GradleDependencyConfiguration.fromToolingModel0(dep, new HashMap<ResolvedGroupArtifactVersion, org.openrewrite.maven.tree.ResolvedDependency>());
    }

    private static org.openrewrite.maven.tree.ResolvedDependency fromToolingModel0(ResolvedDependency dep, Map<ResolvedGroupArtifactVersion, org.openrewrite.maven.tree.ResolvedDependency> resolvedCache) {
        ResolvedGroupArtifactVersion gav = GradleDependencyConfiguration.fromToolingModel(dep.getGav());
        org.openrewrite.maven.tree.ResolvedDependency resolvedDependency = resolvedCache.get(gav);
        if (resolvedDependency != null) {
            return resolvedDependency;
        }
        ArrayList deps = new ArrayList(dep.getDependencies().size());
        resolvedDependency = resolvedCache.computeIfAbsent(gav, k -> org.openrewrite.maven.tree.ResolvedDependency.builder().repository(GradleProject.fromToolingModel(dep.getRepository())).gav(gav).requested(GradleDependencyConfiguration.fromToolingModel(dep.getRequested())).dependencies(deps).licenses(Collections.emptyList()).depth(0).build());
        dep.getDependencies().stream().map(d -> GradleDependencyConfiguration.fromToolingModel0(d, resolvedCache)).forEach(deps::add);
        return resolvedDependency;
    }

    private static org.openrewrite.maven.tree.Dependency fromToolingModel(Dependency dep) {
        return org.openrewrite.maven.tree.Dependency.builder().gav(GradleDependencyConfiguration.fromToolingModel(dep.getGav())).scope(dep.getScope()).type(dep.getType()).exclusions(dep.getExclusions().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList())).optional(dep.getOptional()).build();
    }

    private static GroupArtifact fromToolingModel(org.openrewrite.gradle.toolingapi.GroupArtifact ga) {
        return new GroupArtifact(ga.getGroupId(), ga.getArtifactId());
    }

    private static org.openrewrite.maven.tree.GroupArtifactVersion fromToolingModel(GroupArtifactVersion gav) {
        return new org.openrewrite.maven.tree.GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
    }

    private static ResolvedGroupArtifactVersion fromToolingModel(org.openrewrite.gradle.toolingapi.ResolvedGroupArtifactVersion gav) {
        return new ResolvedGroupArtifactVersion(null, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), gav.getDatedSnapshotVersion());
    }

    public GradleDependencyConfiguration(String name, String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, List<GradleDependencyConfiguration> extendsFrom, List<org.openrewrite.maven.tree.Dependency> requested, List<org.openrewrite.maven.tree.ResolvedDependency> directResolved, List<org.openrewrite.maven.tree.ResolvedDependency> resolved, String exceptionType, String message) {
        this.name = name;
        this.description = description;
        this.isTransitive = isTransitive;
        this.isCanBeResolved = isCanBeResolved;
        this.isCanBeConsumed = isCanBeConsumed;
        this.extendsFrom = extendsFrom;
        this.requested = requested;
        this.directResolved = directResolved;
        this.resolved = resolved;
        this.exceptionType = exceptionType;
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public boolean isCanBeResolved() {
        return this.isCanBeResolved;
    }

    public boolean isCanBeConsumed() {
        return this.isCanBeConsumed;
    }

    public List<GradleDependencyConfiguration> getExtendsFrom() {
        return this.extendsFrom;
    }

    public List<org.openrewrite.maven.tree.Dependency> getRequested() {
        return this.requested;
    }

    public List<org.openrewrite.maven.tree.ResolvedDependency> getDirectResolved() {
        return this.directResolved;
    }

    public List<org.openrewrite.maven.tree.ResolvedDependency> getResolved() {
        return this.resolved;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleDependencyConfiguration)) {
            return false;
        }
        GradleDependencyConfiguration other = (GradleDependencyConfiguration)o;
        if (this.isTransitive() != other.isTransitive()) {
            return false;
        }
        if (this.isCanBeResolved() != other.isCanBeResolved()) {
            return false;
        }
        if (this.isCanBeConsumed() != other.isCanBeConsumed()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<GradleDependencyConfiguration> this$extendsFrom = this.getExtendsFrom();
        List<GradleDependencyConfiguration> other$extendsFrom = other.getExtendsFrom();
        if (this$extendsFrom == null ? other$extendsFrom != null : !((Object)this$extendsFrom).equals(other$extendsFrom)) {
            return false;
        }
        List<org.openrewrite.maven.tree.Dependency> this$requested = this.getRequested();
        List<org.openrewrite.maven.tree.Dependency> other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<org.openrewrite.maven.tree.ResolvedDependency> this$directResolved = this.getDirectResolved();
        List<org.openrewrite.maven.tree.ResolvedDependency> other$directResolved = other.getDirectResolved();
        if (this$directResolved == null ? other$directResolved != null : !((Object)this$directResolved).equals(other$directResolved)) {
            return false;
        }
        List<org.openrewrite.maven.tree.ResolvedDependency> this$resolved = this.getResolved();
        List<org.openrewrite.maven.tree.ResolvedDependency> other$resolved = other.getResolved();
        if (this$resolved == null ? other$resolved != null : !((Object)this$resolved).equals(other$resolved)) {
            return false;
        }
        String this$exceptionType = this.getExceptionType();
        String other$exceptionType = other.getExceptionType();
        if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransitive() ? 79 : 97);
        result = result * 59 + (this.isCanBeResolved() ? 79 : 97);
        result = result * 59 + (this.isCanBeConsumed() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<GradleDependencyConfiguration> $extendsFrom = this.getExtendsFrom();
        result = result * 59 + ($extendsFrom == null ? 43 : ((Object)$extendsFrom).hashCode());
        List<org.openrewrite.maven.tree.Dependency> $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<org.openrewrite.maven.tree.ResolvedDependency> $directResolved = this.getDirectResolved();
        result = result * 59 + ($directResolved == null ? 43 : ((Object)$directResolved).hashCode());
        List<org.openrewrite.maven.tree.ResolvedDependency> $resolved = this.getResolved();
        result = result * 59 + ($resolved == null ? 43 : ((Object)$resolved).hashCode());
        String $exceptionType = this.getExceptionType();
        result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "GradleDependencyConfiguration(name=" + this.getName() + ", description=" + this.getDescription() + ", isTransitive=" + this.isTransitive() + ", isCanBeResolved=" + this.isCanBeResolved() + ", isCanBeConsumed=" + this.isCanBeConsumed() + ", extendsFrom=" + this.getExtendsFrom() + ", requested=" + this.getRequested() + ", directResolved=" + this.getDirectResolved() + ", resolved=" + this.getResolved() + ", exceptionType=" + this.getExceptionType() + ", message=" + this.getMessage() + ")";
    }

    public GradleDependencyConfiguration withName(String name) {
        return this.name == name ? this : new GradleDependencyConfiguration(name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withDescription(String description) {
        return this.description == description ? this : new GradleDependencyConfiguration(this.name, description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withTransitive(boolean isTransitive) {
        return this.isTransitive == isTransitive ? this : new GradleDependencyConfiguration(this.name, this.description, isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withCanBeResolved(boolean isCanBeResolved) {
        return this.isCanBeResolved == isCanBeResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withCanBeConsumed(boolean isCanBeConsumed) {
        return this.isCanBeConsumed == isCanBeConsumed ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        return this.extendsFrom == extendsFrom ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, extendsFrom, this.requested, this.directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withRequested(List<org.openrewrite.maven.tree.Dependency> requested) {
        return this.requested == requested ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, requested, this.directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withDirectResolved(List<org.openrewrite.maven.tree.ResolvedDependency> directResolved) {
        return this.directResolved == directResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, directResolved, this.resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withResolved(List<org.openrewrite.maven.tree.ResolvedDependency> resolved) {
        return this.resolved == resolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, resolved, this.exceptionType, this.message);
    }

    public GradleDependencyConfiguration withExceptionType(String exceptionType) {
        return this.exceptionType == exceptionType ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.resolved, exceptionType, this.message);
    }

    public GradleDependencyConfiguration withMessage(String message) {
        return this.message == message ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.extendsFrom, this.requested, this.directResolved, this.resolved, this.exceptionType, message);
    }
}

