/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.initialization.DefaultSettings;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.util.GradleVersion;
import org.openrewrite.Tree;
import org.openrewrite.gradle.marker.FeaturePreview;
import org.openrewrite.gradle.marker.GradleProjectBuilder;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.MavenRepository;

public final class GradleSettingsBuilder {
    static MavenRepository GRADLE_PLUGIN_PORTAL = MavenRepository.builder().id("Gradle Central Plugin Repository").uri("https://plugins.gradle.org/m2").releases(true).snapshots(true).build();

    private GradleSettingsBuilder() {
    }

    public static GradleSettings gradleSettings(Settings settings) {
        HashSet<MavenRepository> pluginRepositories = new HashSet<MavenRepository>();
        pluginRepositories.addAll(GradleProjectBuilder.mapRepositories((List<ArtifactRepository>)settings.getPluginManagement().getRepositories()));
        pluginRepositories.addAll(GradleProjectBuilder.mapRepositories((List<ArtifactRepository>)settings.getBuildscript().getRepositories()));
        if (pluginRepositories.isEmpty()) {
            pluginRepositories.add(GRADLE_PLUGIN_PORTAL);
        }
        return new GradleSettings(Tree.randomId(), new ArrayList<MavenRepository>(pluginRepositories), GradleProjectBuilder.pluginDescriptors(settings.getPluginManager()), GradleSettingsBuilder.featurePreviews((DefaultSettings)settings));
    }

    private static Map<String, FeaturePreview> featurePreviews(DefaultSettings settings) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.6")) < 0) {
            return Collections.emptyMap();
        }
        HashMap<String, FeaturePreview> featurePreviews = new HashMap<String, FeaturePreview>();
        FeaturePreviews gradleFeaturePreviews = GradleSettingsBuilder.getService(settings, FeaturePreviews.class);
        if (gradleFeaturePreviews != null) {
            FeaturePreviews.Feature[] gradleFeatures;
            for (FeaturePreviews.Feature feature : gradleFeatures = FeaturePreviews.Feature.values()) {
                featurePreviews.put(feature.name(), new FeaturePreview(feature.name(), feature.isActive(), gradleFeaturePreviews.isFeatureEnabled(feature)));
            }
        }
        return featurePreviews;
    }

    @Nullable
    private static <T> T getService(DefaultSettings settings, Class<T> serviceType) {
        try {
            Method services = settings.getClass().getDeclaredMethod("getServices", new Class[0]);
            services.setAccessible(true);
            ServiceRegistry serviceRegistry = (ServiceRegistry)services.invoke((Object)settings, new Object[0]);
            return (T)serviceRegistry.get(serviceType);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | UnknownServiceException e) {
            return null;
        }
    }
}

