/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class SafariCustomProfileLauncher
extends AbstractBrowserLauncher {
    static Log log = LogFactory.getLog(SafariCustomProfileLauncher.class);
    private static final String DEFAULT_LOCATION = "/Applications/Safari.app/Contents/MacOS/Safari";
    private static final String REDIRECT_TO_GO_TO_SELENIUM = "redirect_to_go_to_selenium.htm";
    private File customProfileDir;
    private String[] cmdarray;
    private boolean closed = false;
    private String commandPath = SafariCustomProfileLauncher.findBrowserLaunchLocation();
    private Process process;
    private static AsyncExecute exe = new AsyncExecute();

    public SafariCustomProfileLauncher(int port, String sessionId) {
        this(port, sessionId, SafariCustomProfileLauncher.findBrowserLaunchLocation());
    }

    public SafariCustomProfileLauncher(int port, String sessionId, String browserLaunchLocation) {
        super(sessionId);
        this.sessionId = sessionId;
        if (!WindowsUtils.thisIsWindows()) {
            File execDirect;
            File SafariBin = AsyncExecute.whichExec(this.commandPath);
            if (SafariBin == null && (execDirect = new File(this.commandPath)).isAbsolute() && execDirect.exists()) {
                SafariBin = execDirect;
            }
            if (SafariBin != null) {
                String libPathKey = SafariCustomProfileLauncher.getLibPathKey();
                String libPath = WindowsUtils.loadEnvironment().getProperty(libPathKey);
                exe.setEnvironment(new String[]{libPathKey + "=" + libPath + ":" + SafariBin.getParent()});
            }
        }
        this.customProfileDir = LauncherUtils.createCustomProfileDir(sessionId);
    }

    private static String getLibPathKey() {
        if (WindowsUtils.thisIsWindows()) {
            return WindowsUtils.getExactPathEnvKey();
        }
        if (Os.isFamily("mac")) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    private static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("SafariDefaultPath");
        if (defaultPath == null) {
            defaultPath = DEFAULT_LOCATION;
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File SafariBin = AsyncExecute.whichExec("Safari");
        if (SafariBin != null) {
            return SafariBin.getAbsolutePath();
        }
        throw new RuntimeException("Safari couldn't be found in the path!\nPlease add the directory containing 'Safari' to your PATH environment\nvariable, or explicitly specify a path to Safari like this:\n*Safari /blah/blah/Safari");
    }

    protected void launch(String url) {
        try {
            if (Os.isFamily("mac")) {
                String user = System.getenv("USER");
                File cacheDir = new File("/Users/" + user + "/Library/Caches/Safari");
                File cookiesFile = new File("/Users/" + user + "/Library/Cookies/Cookies.plist");
                LauncherUtils.deleteTryTryAgain(cacheDir, 6);
                if (cookiesFile.exists()) {
                    cookiesFile.delete();
                }
            }
            this.cmdarray = new String[]{this.commandPath};
            String redirectHtmlFileName = this.makeRedirectionHtml(this.customProfileDir, url);
            log.info("Launching Safari to visit " + url + " via " + redirectHtmlFileName + "...");
            this.cmdarray = new String[]{this.commandPath, redirectHtmlFileName};
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String makeRedirectionHtml(File parentDir, String url) {
        PrintStream out;
        File f = new File(parentDir, REDIRECT_TO_GO_TO_SELENIUM);
        try {
            out = new PrintStream(new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("troublemaking redirection HTML: " + e);
        }
        out.println("<script language=\"JavaScript\">\n    location = \"" + url + "\"\n" + "</script>\n" + "");
        out.close();
        return f.getAbsolutePath();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.process == null) {
            return;
        }
        log.info("Killing Safari...");
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            log.warn("Safari seems to have ended on its own (did we kill the real browser???)");
        }
        this.closed = true;
    }

    public Process getProcess() {
        return this.process;
    }

    public static void main(String[] args) throws Exception {
        SafariCustomProfileLauncher l = new SafariCustomProfileLauncher(4444, "CUST");
        l.launch("http://www.google.com");
        int seconds = 15;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }
}

