/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.ResourceHandler;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumDriverResourceHandler
extends ResourceHandler {
    private final Map<String, BrowserLauncher> launchers = new HashMap<String, BrowserLauncher>();
    private SeleniumServer server;
    private static String lastSessionId = null;
    private Map<String, String> domainsBySessionId = new HashMap<String, String>();
    private Map<String, String> unusedBrowserSessions = new HashMap<String, String>();
    private Map<String, String> sessionIdsToBrowserStrings = new HashMap<String, String>();
    private StringBuffer logMessagesBuffer = new StringBuffer();

    public SeleniumDriverResourceHandler(SeleniumServer server) {
        this.server = server;
    }

    private String getParam(HttpRequest req, String name) {
        List parameterValues = req.getParameterValues(name);
        if (parameterValues == null) {
            return null;
        }
        return (String)parameterValues.get(0);
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse res) throws HttpException, IOException {
        try {
            boolean justLoaded;
            res.setField("Content-Type", "text/plain");
            this.setNoCacheHeaders(res);
            String method = req.getMethod();
            String cmd = this.getParam(req, "cmd");
            String sessionId = this.getParam(req, "sessionId");
            String seleniumStart = this.getParam(req, "seleniumStart");
            String loggingParam = this.getParam(req, "logging");
            String jsStateParam = this.getParam(req, "state");
            boolean logging = "true".equals(loggingParam);
            boolean jsState = "true".equals(jsStateParam);
            boolean bl = justLoaded = seleniumStart != null && seleniumStart.equals("true");
            if ("POST".equalsIgnoreCase(method) || justLoaded) {
                RemoteCommand sc;
                FrameAddress frameAddress = FrameGroupCommandQueueSet.makeFrameAddress(this.getParam(req, "seleniumWindowName"), this.getParam(req, "localFrameAddress"), justLoaded);
                String uniqueId = this.getParam(req, "uniqueId");
                String postedData = this.readPostedData(req, sessionId, uniqueId);
                if (logging) {
                    this.handleLogMessages(postedData);
                } else if (jsState) {
                    this.handleJsState(sessionId, uniqueId, postedData);
                }
                if (postedData == null || postedData.equals("") || logging || jsState) {
                    res.getOutputStream().write("\r\n\r\n".getBytes());
                    req.setHandled(true);
                    return;
                }
                this.logPostedData(frameAddress, justLoaded, sessionId, postedData, uniqueId);
                FrameGroupCommandQueueSet queueSet = FrameGroupCommandQueueSet.getOrMakeQueueSet(sessionId);
                SeleniumServer.log("req: " + seleniumStart + ":" + req);
                if (justLoaded) {
                    postedData = "OK";
                }
                if ((sc = queueSet.handleCommandResult(postedData, frameAddress, uniqueId, justLoaded, req.getParameterValues("jsWindowNameVar"))) != null) {
                    this.respond(res, sc);
                }
                req.setHandled(true);
            } else if (cmd != null) {
                SeleniumServer.log(method + ": " + req.getQuery());
                this.handleCommandRequest(req, res, cmd, sessionId);
            } else if (-1 == req.getRequestURL().indexOf("selenium-server/core/scripts/user-extensions.js") && -1 == req.getRequestURL().indexOf("selenium-server/tests/html/tw.jpg")) {
                SeleniumServer.log("Not handling: " + req.getRequestURL() + "?" + req.getQuery());
                req.setHandled(false);
            }
        }
        catch (RuntimeException e) {
            String apparentFile;
            if (!SeleniumServer.isDebugMode() && this.looksLikeBrowserLaunchFailedBecauseFileNotFound(e) && (apparentFile = this.extractNameOfFileThatCouldntBeFound(e)) != null) {
                System.err.println("\n\nCould not start browser; it appears that " + apparentFile + " is missing or inaccessible");
            }
            throw e;
        }
    }

    private void logPostedData(FrameAddress frameAddress, boolean justLoaded, String sessionId, String postedData, String uniqueId) {
        StringBuffer sb = new StringBuffer();
        sb.append("Browser " + sessionId + "/" + frameAddress + " " + uniqueId + " posted " + postedData);
        if (!frameAddress.isDefault()) {
            sb.append(" from " + frameAddress);
        }
        if (justLoaded) {
            sb.append(" NEW");
        }
        SeleniumServer.log(sb.toString());
    }

    private void respond(HttpResponse res, RemoteCommand sc) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(1000);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, "UTF-8");
        if (sc != null) {
            writer.write(sc.toString());
        }
        int pad = 998 - buf.size();
        while (pad-- > 0) {
            writer.write(" ");
        }
        writer.write("\r\n");
        ((Writer)writer).close();
        OutputStream out = res.getOutputStream();
        buf.writeTo(out);
    }

    private String readPostedData(HttpRequest req, String sessionId, String uniqueId) throws IOException {
        int c;
        InputStream is = req.getInputStream();
        StringBuffer sb = new StringBuffer();
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        while ((c = r.read()) != -1) {
            sb.append((char)c);
        }
        String s = sb.toString();
        return s;
    }

    private void handleLogMessages(String s) {
        String logMessages = this.grepStringsStartingWith("logLevel=", s);
        if (logMessages == null) {
            return;
        }
        logMessages = "\t" + logMessages.replaceAll("\n", "\n\t");
        logMessages = logMessages.replaceFirst("\t$", "");
        this.logMessagesBuffer.append(logMessages);
        SeleniumServer.log(logMessages);
    }

    private void handleJsState(String sessionId, String uniqueId, String s) {
        String jsInitializers = this.grepStringsStartingWith("state:", s);
        if (jsInitializers == null) {
            return;
        }
        for (String jsInitializer : jsInitializers.split("\n")) {
            String jsVarName = this.extractVarName(jsInitializer);
            InjectionHelper.saveJsStateInitializer(sessionId, uniqueId, jsVarName, jsInitializer);
        }
    }

    private String extractVarName(String jsInitializer) {
        int x = jsInitializer.indexOf(61);
        if (x == -1) {
            x = jsInitializer.lastIndexOf(40);
            if (x == -1) {
                throw new RuntimeException("expected method call, saw " + jsInitializer);
            }
            if ((x = jsInitializer.lastIndexOf(46, x - 1)) == -1) {
                throw new RuntimeException("expected method call, saw " + jsInitializer);
            }
        }
        return jsInitializer.substring(0, x);
    }

    private String grepStringsStartingWith(String pattern, String s) {
        String[] lines = s.split("\n");
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            if (!line.startsWith(pattern)) continue;
            sb.append(line.substring(pattern.length())).append('\n');
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private String extractNameOfFileThatCouldntBeFound(Exception e) {
        String s = e.getMessage();
        if (s == null) {
            return null;
        }
        return s.replaceFirst(".*CreateProcess: ", "").replaceFirst(" .*", "");
    }

    private boolean looksLikeBrowserLaunchFailedBecauseFileNotFound(Exception e) {
        String s = e.getMessage();
        return s != null && s.matches("java.io.IOException: CreateProcess: .*error=3");
    }

    private void handleCommandRequest(HttpRequest req, HttpResponse res, String cmd, String sessionId) {
        String results;
        res.setContentType("text/plain");
        this.hackRemoveConnectionCloseHeader(res);
        Vector<String> values = new Vector<String>();
        int i = 1;
        while (req.getParameter(Integer.toString(i)) != null) {
            values.add(req.getParameter(Integer.toString(i)));
            ++i;
        }
        if (values.size() < 1) {
            values.add("");
        }
        if (values.size() < 2) {
            values.add("");
        }
        if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log("queryString = " + req.getQuery());
        }
        if ((results = this.doCommand(cmd, values, sessionId, res)) != null) {
            try {
                res.getOutputStream().write(results.getBytes("UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        req.setHandled(true);
    }

    public String doCommand(String cmd, Vector<String> values, String sessionId, HttpResponse res) {
        String results;
        if ("getNewBrowserSession".equals(cmd)) {
            String browserString = values.get(0);
            sessionId = this.getNewBrowserSession(browserString, values.get(1));
            this.setDomain(sessionId, values.get(1));
            results = "OK," + sessionId;
        } else if ("getLogMessages".equals(cmd)) {
            results = "OK," + this.logMessagesBuffer.toString();
            this.logMessagesBuffer.setLength(0);
        } else if ("testComplete".equals(cmd)) {
            results = this.endBrowserSession(sessionId, SeleniumServer.reusingBrowserSessions());
        } else if ("shutDown".equals(cmd)) {
            results = null;
            this.shutDown(res);
        } else if ("isPostSupported".equals(cmd)) {
            results = "OK,false";
        } else if ("setSpeed".equals(cmd)) {
            try {
                CommandQueue.setSpeed(Integer.parseInt(values.get(0)));
            }
            catch (NumberFormatException e) {
                return "ERROR: setSlowMode expects a string containing an integer, but saw '" + values.get(0) + "'";
            }
            results = "OK";
        } else if ("getSpeed".equals(cmd)) {
            results = "OK," + CommandQueue.getSpeed();
        } else if ("addStaticContent".equals(cmd)) {
            File dir = new File(values.get(0));
            if (dir.exists()) {
                this.server.addNewStaticContent(dir);
                results = "OK";
            } else {
                results = "ERROR: dir does not exist - " + dir.getAbsolutePath();
            }
        } else if ("runHTMLSuite".equals(cmd)) {
            HTMLLauncher launcher = new HTMLLauncher(this.server);
            File output = null;
            if (values.size() < 4) {
                results = "ERROR: Not enough arguments (browser, browserURL, suiteURL, multiWindow, [outputFile])";
            } else {
                if (values.size() > 4) {
                    output = new File(values.get(4));
                }
                try {
                    results = launcher.runHTMLSuite(values.get(0), values.get(1), values.get(2), output, SeleniumServer.getTimeoutInSeconds(), "true".equals(values.get(3)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    results = e.toString();
                }
            }
        } else {
            if ("open".equals(cmd)) {
                this.warnIfApparentDomainChange(sessionId, values.get(0));
            }
            FrameGroupCommandQueueSet queue = FrameGroupCommandQueueSet.getOrMakeQueueSet(sessionId);
            results = queue.doCommand(cmd, values.get(0), values.get(1));
        }
        SeleniumServer.log("Got result: " + results + " on session " + sessionId);
        return results;
    }

    private void shutDown(HttpResponse res) {
        SeleniumServer.log("Shutdown command received");
        Runnable initiateShutDown = new Runnable(){

            public void run() {
                SeleniumServer.log("initiating shutdown");
                AsyncExecute.sleepTight(500L);
                System.exit(0);
            }
        };
        Thread isd = new Thread(initiateShutDown);
        isd.setName("initiateShutDown");
        isd.start();
        if (res != null) {
            try {
                res.getOutputStream().write("OK".getBytes());
                res.commit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String endBrowserSession(String sessionId, boolean cacheUnused) {
        if (cacheUnused) {
            this.addUnusedBrowserSession(sessionId);
        } else {
            BrowserLauncher launcher = this.getLauncher(sessionId);
            if (launcher == null) {
                return "ERROR: No launcher found for sessionId " + sessionId;
            }
            launcher.close();
            FrameGroupCommandQueueSet.clearQueueSet(sessionId);
        }
        return "OK";
    }

    private void warnIfApparentDomainChange(String sessionId, String url) {
        if (url.startsWith("http://")) {
            String urlDomain = url.replaceFirst("^(http://[^/]+, url)/.*", "$1");
            String domain = this.getDomain(sessionId);
            if (domain == null) {
                this.setDomain(sessionId, urlDomain);
            } else if (!url.startsWith(domain)) {
                System.err.println("warning: you appear to be changing domains from " + domain + " to " + urlDomain + "\n" + "this may lead to a 'Permission denied' from the browser (unless it is running as *iehta or *chrome,\n" + "or alternatively the selenium server is running in proxy injection mode)");
            }
        }
    }

    private String getNewBrowserSession(String browserString, String startURL) {
        CommandQueue queue;
        if (SeleniumServer.getForcedBrowserMode() != null) {
            browserString = SeleniumServer.getForcedBrowserMode();
            SeleniumServer.log("overriding browser mode w/ forced browser mode setting: " + browserString);
        }
        if (SeleniumServer.isProxyInjectionMode() && browserString.equals("*iexplore")) {
            SeleniumServer.log("WARNING: running in proxy injection mode, but you used a *iexplore browser string; this is almost surely inappropriate, so I'm changing it to *piiexplore...");
            browserString = "*piiexplore";
        } else if (SeleniumServer.isProxyInjectionMode() && browserString.equals("*firefox")) {
            SeleniumServer.log("WARNING: running in proxy injection mode, but you used a *firefox browser string; this is almost surely inappropriate, so I'm changing it to *pifirefox...");
            browserString = "*pifirefox";
        }
        if (SeleniumServer.isProxyInjectionMode()) {
            InjectionHelper.init();
        }
        if (browserString == null) {
            throw new IllegalArgumentException("browser string may not be null");
        }
        String sessionId = this.getUnusedBrowserSession(browserString);
        if (sessionId != null) {
            SeleniumDriverResourceHandler.setLastSessionId(sessionId);
            queue = FrameGroupCommandQueueSet.getOrMakeQueueSet(sessionId).getCommandQueue();
        } else {
            sessionId = Long.toString(System.currentTimeMillis() % 1000000L);
            SeleniumDriverResourceHandler.setLastSessionId(sessionId);
            BrowserLauncherFactory blf = new BrowserLauncherFactory(this.server);
            queue = FrameGroupCommandQueueSet.getOrMakeQueueSet(sessionId).getCommandQueue();
            BrowserLauncher launcher = blf.getBrowserLauncher(browserString, sessionId, queue);
            this.launchers.put(sessionId, launcher);
            this.sessionIdsToBrowserStrings.put(sessionId, browserString);
            queue.setResultExpected(true);
            boolean multiWindow = this.server.isMultiWindow();
            launcher.launchRemoteSession(startURL, multiWindow);
            queue.discardCommandResult();
            queue.setResultExpected(false);
        }
        SeleniumServer.log("Allocated session " + sessionId + " for " + startURL);
        queue.doCommand("setContext", sessionId, "");
        return sessionId;
    }

    private String getUnusedBrowserSession(String browserString) {
        return this.unusedBrowserSessions.remove(browserString);
    }

    private void addUnusedBrowserSession(String sessionId) {
        FrameGroupCommandQueueSet.getOrMakeQueueSet(sessionId).reset();
        this.unusedBrowserSessions.put(this.sessionIdsToBrowserStrings.get(sessionId), sessionId);
    }

    private void hackRemoveConnectionCloseHeader(HttpResponse res) {
        res.removeField("Connection");
        Field[] fields = HttpConnection.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field _close;
            if (fields[i].getName().equals("_close")) {
                _close = fields[i];
                _close.setAccessible(true);
                try {
                    _close.setBoolean(res.getHttpConnection(), false);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (!fields[i].getName().equals("_persistent")) continue;
            _close = fields[i];
            _close.setAccessible(true);
            try {
                _close.setBoolean(res.getHttpConnection(), true);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrowserLauncher getLauncher(String sessionId) {
        Map<String, BrowserLauncher> map = this.launchers;
        synchronized (map) {
            return this.launchers.get(sessionId);
        }
    }

    public void registerBrowserLauncher(String sessionId, BrowserLauncher launcher) {
        this.launchers.put(sessionId, launcher);
    }

    public void stopAllBrowsers() {
        for (BrowserLauncher launcher : this.launchers.values()) {
            launcher.close();
        }
    }

    private void setNoCacheHeaders(HttpResponse res) {
        res.setField("Cache-Control", "no-cache");
        res.setField("Pragma", "no-cache");
        res.setField("Expires", HttpFields.__01Jan1970);
    }

    private void setDomain(String sessionId, String domain) {
        this.domainsBySessionId.put(sessionId, domain);
    }

    private String getDomain(String sessionId) {
        return this.domainsBySessionId.get(sessionId);
    }

    public static String getLastSessionId() {
        return lastSessionId;
    }

    private static void setLastSessionId(String sessionId) {
        lastSessionId = sessionId;
    }
}

