/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.LogSupport;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private static Log log = LogFactory.getLog(class$org$mortbay$xml$XmlParser == null ? (class$org$mortbay$xml$XmlParser = XmlParser.class$("org.mortbay.xml.XmlParser")) : class$org$mortbay$xml$XmlParser);
    private Map _redirectMap = new HashMap();
    private SAXParser _parser;
    private String _xpath;
    private Object _xpaths;
    static /* synthetic */ Class class$org$mortbay$xml$XmlParser;

    public XmlParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            boolean notValidating = Boolean.getBoolean("org.mortbay.xml.XmlParser.NotValidating");
            factory.setValidating(!notValidating);
            this._parser = factory.newSAXParser();
            try {
                if (!notValidating) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", true);
                }
            }
            catch (Exception e) {
                log.warn("Schema validation may not be supported");
                log.debug("", e);
                notValidating = true;
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", !notValidating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", !notValidating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", !notValidating);
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
            throw new Error(e.toString());
        }
    }

    public XmlParser(boolean validating) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(validating);
            this._parser = factory.newSAXParser();
            try {
                if (validating) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", validating);
                }
            }
            catch (Exception e) {
                if (validating) {
                    log.warn("Schema validation may not be supported: ", e);
                }
                LogSupport.ignore(log, e);
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", validating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", validating);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", validating);
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
            throw new Error(e.toString());
        }
    }

    public synchronized void redirectEntity(String name, URL entity) {
        if (entity != null) {
            this._redirectMap.put(name, entity);
        }
    }

    public String getXpath() {
        return this._xpath;
    }

    public void setXpath(String xpath) {
        this._xpath = xpath;
        StringTokenizer tok = new StringTokenizer(xpath, "| ");
        while (tok.hasMoreTokens()) {
            this._xpaths = LazyList.add(this._xpaths, tok.nextToken());
        }
    }

    public synchronized Node parse(InputSource source) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader reader = this._parser.getXMLReader();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        if (log.isDebugEnabled()) {
            log.debug("parsing: sid=" + source.getSystemId() + ",pid=" + source.getPublicId());
        }
        this._parser.parse(source, (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node doc = (Node)handler._top.get(0);
        handler.clear();
        return doc;
    }

    public synchronized Node parse(String url) throws IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug("parse: " + url);
        }
        return this.parse(new InputSource(url));
    }

    public synchronized Node parse(File file) throws IOException, SAXException {
        if (log.isDebugEnabled()) {
            log.debug("parse: " + file);
        }
        return this.parse(new InputSource(file.toURL().toString()));
    }

    public synchronized Node parse(InputStream in) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader reader = this._parser.getXMLReader();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        this._parser.parse(new InputSource(in), (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node doc = (Node)handler._top.get(0);
        handler.clear();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node parse(URL url) throws IOException, SAXException {
        Node n = null;
        InputStream is = url.openStream();
        try {
            n = this.parse(is);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        return n;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Node
    extends AbstractList {
        Node _parent;
        private ArrayList _list;
        private String _tag;
        private Attribute[] _attrs;
        private boolean _lastString = false;
        private String _path;

        Node(Node parent, String tag, Attributes attrs) {
            this._parent = parent;
            this._tag = tag;
            if (attrs != null) {
                this._attrs = new Attribute[attrs.getLength()];
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String name = attrs.getLocalName(i);
                    if (name == null || name.equals("")) {
                        name = attrs.getQName(i);
                    }
                    this._attrs[i] = new Attribute(name, attrs.getValue(i));
                }
            }
        }

        public Node getParent() {
            return this._parent;
        }

        public String getTag() {
            return this._tag;
        }

        public String getPath() {
            if (this._path == null) {
                this._path = this.getParent() != null && this.getParent().getTag() != null ? this.getParent().getPath() + "/" + this._tag : "/" + this._tag;
            }
            return this._path;
        }

        public Attribute[] getAttributes() {
            return this._attrs;
        }

        public String getAttribute(String name) {
            return this.getAttribute(name, null);
        }

        public String getAttribute(String name, String dft) {
            if (this._attrs == null || name == null) {
                return dft;
            }
            for (int i = 0; i < this._attrs.length; ++i) {
                if (!name.equals(this._attrs[i].getName())) continue;
                return this._attrs[i].getValue();
            }
            return dft;
        }

        public int size() {
            if (this._list != null) {
                return this._list.size();
            }
            return 0;
        }

        public Object get(int i) {
            if (this._list != null) {
                return this._list.get(i);
            }
            return null;
        }

        public Node get(String tag) {
            if (this._list != null) {
                for (int i = 0; i < this._list.size(); ++i) {
                    Object o = this._list.get(i);
                    if (!(o instanceof Node)) continue;
                    Node n = (Node)o;
                    if (!tag.equals(n._tag)) continue;
                    return n;
                }
            }
            return null;
        }

        public void add(int i, Object o) {
            if (this._list == null) {
                this._list = new ArrayList();
            }
            if (o instanceof String) {
                if (this._lastString) {
                    int last = this._list.size() - 1;
                    this._list.set(last, (String)this._list.get(last) + o);
                } else {
                    this._list.add(i, o);
                }
                this._lastString = true;
            } else {
                this._lastString = false;
                this._list.add(i, o);
            }
        }

        public void clear() {
            if (this._list != null) {
                this._list.clear();
            }
            this._list = null;
        }

        public String getString(String tag, boolean tags, boolean trim) {
            Node node = this.get(tag);
            if (node == null) {
                return null;
            }
            String s = node.toString(tags);
            if (s != null && trim) {
                s = s.trim();
            }
            return s;
        }

        public synchronized String toString() {
            return this.toString(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String toString(boolean tag) {
            StringBuffer buf;
            StringBuffer stringBuffer = buf = new StringBuffer();
            synchronized (stringBuffer) {
                this.toString(buf, tag);
                return buf.toString();
            }
        }

        public synchronized String toString(boolean tag, boolean trim) {
            String s = this.toString(tag);
            if (s != null && trim) {
                s = s.trim();
            }
            return s;
        }

        private synchronized void toString(StringBuffer buf, boolean tag) {
            int i;
            if (tag) {
                buf.append("<");
                buf.append(this._tag);
                if (this._attrs != null) {
                    for (i = 0; i < this._attrs.length; ++i) {
                        buf.append(' ');
                        buf.append(this._attrs[i].getName());
                        buf.append("=\"");
                        buf.append(this._attrs[i].getValue());
                        buf.append("\"");
                    }
                }
            }
            if (this._list != null) {
                if (tag) {
                    buf.append(">");
                }
                for (i = 0; i < this._list.size(); ++i) {
                    Object o = this._list.get(i);
                    if (o == null) continue;
                    if (o instanceof Node) {
                        ((Node)o).toString(buf, tag);
                        continue;
                    }
                    buf.append(o.toString());
                }
                if (tag) {
                    buf.append("</");
                    buf.append(this._tag);
                    buf.append(">");
                }
            } else if (tag) {
                buf.append("/>");
            }
        }

        public Iterator iterator(String tag) {
            return new Iterator(this, tag){
                int c;
                Node _node;
                private final /* synthetic */ String val$tag;
                private final /* synthetic */ Node this$0;
                {
                    this.this$0 = this$0;
                    this.val$tag = val$tag;
                    this.c = 0;
                }

                public boolean hasNext() {
                    if (this._node != null) {
                        return true;
                    }
                    while (Node.access$400(this.this$0) != null && this.c < Node.access$400(this.this$0).size()) {
                        Node n;
                        E o = Node.access$400(this.this$0).get(this.c);
                        if (o instanceof Node && this.val$tag.equals(Node.access$500(n = (Node)o))) {
                            this._node = n;
                            return true;
                        }
                        ++this.c;
                    }
                    return false;
                }

                public Object next() {
                    try {
                        if (this.hasNext()) {
                            Node node = this._node;
                            return node;
                        }
                        throw new NoSuchElementException();
                    }
                    finally {
                        this._node = null;
                        ++this.c;
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }

        static /* synthetic */ ArrayList access$400(Node x0) {
            return x0._list;
        }

        static /* synthetic */ String access$500(Node x0) {
            return x0._tag;
        }
    }

    public static class Attribute {
        private String _name;
        private String _value;

        Attribute(String n, String v) {
            this._name = n;
            this._value = v;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }

    private class Handler
    extends DefaultHandler {
        Node _top;
        SAXParseException _error;
        private Node _context;
        private NoopHandler _noop;

        Handler() {
            this._context = this._top = new Node(null, null, null);
            this._noop = new NoopHandler(this);
        }

        void clear() {
            this._top = null;
            this._error = null;
            this._context = null;
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String name = uri == null || uri.equals("") ? qName : localName;
            Node node = new Node(this._context, name, attrs);
            if (XmlParser.this._xpaths != null) {
                String path = node.getPath();
                boolean match = false;
                int i = LazyList.size(XmlParser.this._xpaths);
                while (!match && i-- > 0) {
                    String xpath = (String)LazyList.get(XmlParser.this._xpaths, i);
                    match = path.equals(xpath) || xpath.startsWith(path) && xpath.length() > path.length() && xpath.charAt(path.length()) == '/';
                }
                if (match) {
                    this._context.add(node);
                    this._context = node;
                } else {
                    XmlParser.this._parser.getXMLReader().setContentHandler(this._noop);
                }
            } else {
                this._context.add(node);
                this._context = node;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this._context = this._context._parent;
        }

        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            this._context.add(new String(buf, offset, len));
        }

        public void warning(SAXParseException ex) {
            log.debug("EXCEPTION ", ex);
            log.warn("WARNING@" + this.getLocationString(ex) + " : " + ex.toString());
        }

        public void error(SAXParseException ex) throws SAXException {
            if (this._error == null) {
                this._error = ex;
            }
            log.debug("EXCEPTION ", ex);
            log.warn("ERROR@" + this.getLocationString(ex) + " : " + ex.toString());
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this._error = ex;
            log.debug("EXCEPTION ", ex);
            log.warn("FATAL@" + this.getLocationString(ex) + " : " + ex.toString());
            throw ex;
        }

        private String getLocationString(SAXParseException ex) {
            return ex.getSystemId() + " line:" + ex.getLineNumber() + " col:" + ex.getColumnNumber();
        }

        public InputSource resolveEntity(String pid, String sid) {
            if (log.isDebugEnabled()) {
                log.debug("resolveEntity(" + pid + ", " + sid + ")");
            }
            URL entity = null;
            if (pid != null) {
                entity = (URL)XmlParser.this._redirectMap.get(pid);
            }
            if (entity == null) {
                entity = (URL)XmlParser.this._redirectMap.get(sid);
            }
            if (entity == null) {
                String dtd = sid;
                if (dtd.lastIndexOf(47) >= 0) {
                    dtd = dtd.substring(dtd.lastIndexOf(47) + 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Can't exact match entity in redirect map, trying " + dtd);
                }
                entity = (URL)XmlParser.this._redirectMap.get(dtd);
            }
            if (entity != null) {
                try {
                    InputStream in = entity.openStream();
                    if (log.isDebugEnabled()) {
                        log.debug("Redirected entity " + sid + " --> " + entity);
                    }
                    InputSource is = new InputSource(in);
                    is.setSystemId(sid);
                    return is;
                }
                catch (IOException e) {
                    LogSupport.ignore(log, e);
                }
            }
            return null;
        }
    }

    private class NoopHandler
    extends DefaultHandler {
        Handler _next;
        int _depth;

        NoopHandler(Handler next) {
            this._next = next;
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            ++this._depth;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this._depth == 0) {
                XmlParser.this._parser.getXMLReader().setContentHandler(this._next);
            } else {
                --this._depth;
            }
        }
    }
}

